/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.inject.Module;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.MemoryJamesConfiguration;
import org.apache.james.MemoryJamesServerMain;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.spamassassin.SpamAssassinContract;
import org.apache.james.spamassassin.SpamAssassinExtension;
import org.apache.james.spamassassin.module.SpamAssassinModuleExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.RegisterExtension;

class MemorySpamAssassinTest
implements SpamAssassinContract {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> MemoryJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().usersRepository(UsersRepositoryModuleChooser.Implementation.DEFAULT).build()).extension((GuiceModuleTestExtension)new SpamAssassinModuleExtension()).server(configuration -> MemoryJamesServerMain.createServer((MemoryJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).build();

    MemorySpamAssassinTest() {
    }

    @Override
    @Tag(value="unstable")
    public void spamShouldBeDeliveredInSpamMailboxWhenSameMessageHasAlreadyBeenMovedToSpam(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.spamShouldBeDeliveredInSpamMailboxWhenSameMessageHasAlreadyBeenMovedToSpam(jamesServer, spamAssassin);
    }

    @Override
    @Tag(value="unstable")
    public void spamShouldBeDeliveredInSpamMailboxOrInboxWhenMultipleRecipientsConfigurations(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.spamShouldBeDeliveredInSpamMailboxOrInboxWhenMultipleRecipientsConfigurations(jamesServer, spamAssassin);
    }

    @Override
    @Tag(value="unstable")
    public void movingAMailToTrashShouldNotImpactSpamassassinLearning(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.movingAMailToTrashShouldNotImpactSpamassassinLearning(jamesServer, spamAssassin);
    }

    @Override
    @Tag(value="unstable")
    public void expungingSpamMessageShouldNotImpactSpamAssassinState(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.expungingSpamMessageShouldNotImpactSpamAssassinState(jamesServer, spamAssassin);
    }

    @Override
    @Tag(value="unstable")
    public void imapMovesToSpamMailboxShouldBeConsideredAsSpam(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.imapMovesToSpamMailboxShouldBeConsideredAsSpam(jamesServer, spamAssassin);
    }

    @Override
    @Tag(value="unstable")
    public void imapCopiesToSpamMailboxShouldBeConsideredAsSpam(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.imapCopiesToSpamMailboxShouldBeConsideredAsSpam(jamesServer, spamAssassin);
    }

    @Override
    @Tag(value="unstable")
    public void deletingSpamMessageShouldNotImpactSpamAssassinState(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        SpamAssassinContract.super.deletingSpamMessageShouldNotImpactSpamAssassinState(jamesServer, spamAssassin);
    }
}

