/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

final class MonoSumFloat<T>
extends MonoFromFluxOperator<T, Float>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumFloat(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Float> s) {
        this.source.subscribe(new SumLongSubscriber<T>(s, this.mapping));
    }

    static final class SumLongSubscriber<T>
    extends MathSubscriber<T, Float> {
        final Function<? super T, ? extends Number> mapping;
        float sum;
        boolean hasValue;

        SumLongSubscriber(CoreSubscriber<? super Float> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            float floatValue = this.mapping.apply(newValue).floatValue();
            this.sum = this.hasValue ? this.sum + floatValue : floatValue;
            this.hasValue = true;
        }

        @Override
        protected Float result() {
            return this.hasValue ? Float.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0.0f;
            this.hasValue = false;
        }
    }
}

