/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.lang3.StringUtils;

public class DelegatedPropertiesConfiguration
implements Configuration {
    private final char delimiter;
    private final Configuration configuration;

    DelegatedPropertiesConfiguration(char delimiter, Configuration configuration) {
        this.delimiter = delimiter;
        this.configuration = configuration;
    }

    @Override
    public Configuration subset(String prefix) {
        return this.configuration.subset(prefix);
    }

    @Override
    public void addProperty(String key, Object value) {
        this.configuration.addProperty(key, value);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.configuration.setProperty(key, value);
    }

    @Override
    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    @Override
    public void clear() {
        this.configuration.clear();
    }

    @Override
    public ConfigurationInterpolator getInterpolator() {
        return this.configuration.getInterpolator();
    }

    @Override
    public void setInterpolator(ConfigurationInterpolator ci) {
        this.configuration.setInterpolator(ci);
    }

    @Override
    public void installInterpolator(Map<String, ? extends Lookup> prefixLookups, Collection<? extends Lookup> defLookups) {
        this.configuration.installInterpolator(prefixLookups, defLookups);
    }

    @Override
    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    @Override
    public int size() {
        return this.configuration.size();
    }

    @Override
    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        return this.configuration.getKeys(prefix);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.configuration.getKeys();
    }

    @Override
    public Properties getProperties(String key) {
        return this.configuration.getProperties(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.configuration.getBoolean(key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    @Override
    public byte getByte(String key) {
        return this.configuration.getByte(key);
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.configuration.getByte(key, defaultValue);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return this.configuration.getByte(key, defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.configuration.getDouble(key);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.configuration.getDouble(key, defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return this.configuration.getDouble(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.configuration.getFloat(key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.configuration.getFloat(key, defaultValue);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return this.configuration.getFloat(key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.configuration.getInteger(key, defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.configuration.getLong(key);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    @Override
    public short getShort(String key) {
        return this.configuration.getShort(key);
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.configuration.getShort(key, defaultValue);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return this.configuration.getShort(key, defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.configuration.getBigDecimal(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.configuration.getBigDecimal(key, defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.configuration.getBigInteger(key);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.configuration.getBigInteger(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.configuration.getString(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    @Override
    public String getEncodedString(String key, ConfigurationDecoder decoder) {
        return this.configuration.getEncodedString(key, decoder);
    }

    @Override
    public String getEncodedString(String key) {
        return this.configuration.getEncodedString(key);
    }

    @Override
    public String[] getStringArray(String key) {
        return (String[])this.configuration.getList(key).stream().map(String.class::cast).flatMap(this::splitAndStripDoubleQuotes).toArray(String[]::new);
    }

    @Override
    public List<Object> getList(String key) {
        try {
            return (List)this.configuration.getList(key).stream().map(String.class::cast).flatMap(this::splitAndStripDoubleQuotes).collect(ImmutableList.toImmutableList());
        }
        catch (ConversionException e) {
            return this.configuration.getList(key);
        }
        catch (NoSuchElementException e) {
            return ImmutableList.of();
        }
    }

    @Override
    public List<Object> getList(String key, List<?> defaultValue) {
        return this.configuration.getList(key, defaultValue);
    }

    @Override
    public <T> T get(Class<T> cls, String key) {
        return this.configuration.get(cls, key);
    }

    @Override
    public <T> T get(Class<T> cls, String key, T defaultValue) {
        return this.configuration.get(cls, key, defaultValue);
    }

    @Override
    public Object getArray(Class<?> cls, String key) {
        return this.configuration.getArray(cls, key);
    }

    @Override
    @Deprecated
    public Object getArray(Class<?> cls, String key, Object defaultValue) {
        return this.configuration.getArray(cls, key, defaultValue);
    }

    @Override
    public <T> List<T> getList(Class<T> cls, String key) {
        return this.configuration.getList(cls, key);
    }

    @Override
    public <T> List<T> getList(Class<T> cls, String key, List<T> defaultValue) {
        return this.configuration.getList(cls, key, defaultValue);
    }

    @Override
    public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target) {
        return this.configuration.getCollection(cls, key, target);
    }

    @Override
    public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target, Collection<T> defaultValue) {
        return this.configuration.getCollection(cls, key, target, defaultValue);
    }

    @Override
    public ImmutableConfiguration immutableSubset(String prefix) {
        return this.configuration.immutableSubset(prefix);
    }

    @Override
    public Synchronizer getSynchronizer() {
        return this.configuration.getSynchronizer();
    }

    @Override
    public void setSynchronizer(Synchronizer sync) {
        this.configuration.setSynchronizer(sync);
    }

    @Override
    public void lock(LockMode mode) {
        this.configuration.lock(mode);
    }

    @Override
    public void unlock(LockMode mode) {
        this.configuration.unlock(mode);
    }

    private Stream<String> splitAndStripDoubleQuotes(String value) {
        return Optional.ofNullable(value).filter(s -> !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{s})).map(notNullValue -> Stream.of(StringUtils.split((String)StringUtils.strip((String)notNullValue, (String)"\""), (char)this.delimiter)).map(String::trim).filter(s -> !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{s}))).orElseGet(Stream::empty);
    }
}

