/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.github.fge.lambdas.Throwing;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.Host;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMailet;

public class SpamAssassin
extends GenericMailet {
    private final MetricFactory metricFactory;
    private final UsersRepository usersRepository;
    private final Host spamAssassinHost;

    @Inject
    public SpamAssassin(MetricFactory metricFactory, UsersRepository usersRepository, SpamAssassinConfiguration spamAssassinConfiguration) {
        this.metricFactory = metricFactory;
        this.usersRepository = usersRepository;
        this.spamAssassinHost = spamAssassinConfiguration.getHost();
    }

    @Override
    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        SpamAssassinInvoker sa = new SpamAssassinInvoker(this.metricFactory, this.spamAssassinHost.getHostName(), this.spamAssassinHost.getPort());
        mail.getRecipients().forEach(Throwing.consumer(recipient -> this.querySpamAssassin(mail, message, sa, (MailAddress)recipient)).sneakyThrow());
    }

    private void querySpamAssassin(Mail mail, MimeMessage message, SpamAssassinInvoker sa, MailAddress recipient) throws MessagingException, UsersRepositoryException {
        SpamAssassinResult result = sa.scanMail(message, this.usersRepository.getUsername(recipient));
        for (Attribute attribute : result.getHeadersAsAttributes()) {
            mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(attribute.getName().asString()).value((String)attribute.getValue().value()).build(), recipient);
        }
    }

    @Override
    public String getMailetInfo() {
        return "Checks message against SpamAssassin";
    }
}

