/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.managesieve.file.host;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mpt.host.JamesManageSieveHostSystem;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.file.SieveFileRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;

public class FileHostSystem
extends JamesManageSieveHostSystem {
    private static final String SIEVE_ROOT = "file://sieve";
    private static final FileSystem fileSystem = FileHostSystem.getFileSystem();
    private static final DomainList NO_DOMAIN_LIST = null;

    private static FileSystem getFileSystem() {
        return new FileSystem(){

            public File getBasedir() throws FileNotFoundException {
                return new File(System.getProperty("java.io.tmpdir"));
            }

            public InputStream getResource(String url) throws IOException {
                return new FileInputStream(this.getFile(url));
            }

            public File getFile(String fileURL) throws FileNotFoundException {
                return new File(this.getBasedir(), fileURL.substring("file://".length()));
            }
        };
    }

    protected UsersRepository createUsersRepository() {
        return MemoryUsersRepository.withoutVirtualHosting((DomainList)NO_DOMAIN_LIST);
    }

    protected SieveRepository createSieveRepository() throws Exception {
        return new SieveFileRepository(fileSystem);
    }

    public void afterTest() throws Exception {
        super.afterTest();
        File root = fileSystem.getFile(SIEVE_ROOT);
        if (root.exists()) {
            FileUtils.forceDelete((File)root);
        }
    }
}

