/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.host;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SessionTerminatedException;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieve.util.SettableSession;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.helper.ByteBufferInputStream;
import org.apache.james.mpt.helper.ByteBufferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSieveSession
implements org.apache.james.mpt.api.Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveSession.class);
    private final ByteBufferOutputStream out;
    private final ByteBufferInputStream in;
    private final ManageSieveProcessor manageSieveProcessor;
    private final SettableSession settableSession;
    private boolean isReadLast = true;

    public ManageSieveSession(ManageSieveProcessor manageSieveProcessor, Continuation continuation) {
        this.manageSieveProcessor = manageSieveProcessor;
        this.out = new ByteBufferOutputStream(continuation);
        this.in = new ByteBufferInputStream();
        this.settableSession = new SettableSession();
    }

    public String readLine() throws Exception {
        if (!this.isReadLast) {
            String response;
            StringWriter stringWriter = new StringWriter();
            IOUtils.copy((InputStream)this.in, (Writer)stringWriter, (Charset)StandardCharsets.UTF_8);
            String request = stringWriter.toString();
            try {
                response = this.manageSieveProcessor.handleRequest((Session)this.settableSession, request);
            }
            catch (SessionTerminatedException e) {
                LOGGER.info("Session is terminated");
                response = "OK channel is closing\r\n";
            }
            this.out.write(response);
            this.isReadLast = true;
        }
        if (this.settableSession.getState() == Session.State.SSL_NEGOCIATION) {
            this.settableSession.setState(Session.State.UNAUTHENTICATED);
            this.settableSession.setSslEnabled(true);
        }
        return this.out.nextLine();
    }

    public void start() {
    }

    public void stop() {
    }

    public void restart() {
    }

    public void await() {
    }

    public void writeLine(String line) {
        this.isReadLast = false;
        this.in.nextLine(line);
    }
}

