/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.host;

import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.core.CoreProcessor;
import org.apache.james.managesieve.jsieve.Parser;
import org.apache.james.managesieve.transcode.ArgumentParser;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.host.ManageSieveHostSystem;
import org.apache.james.mpt.host.ManageSieveSession;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.jsieve.ConfigurationManager;

public abstract class JamesManageSieveHostSystem
implements ManageSieveHostSystem {
    private UsersRepository usersRepository;
    private SieveRepository sieveRepository;
    private ManageSieveProcessor processor;

    public void beforeTest() throws Exception {
        this.usersRepository = this.createUsersRepository();
        this.sieveRepository = this.createSieveRepository();
        this.processor = new ManageSieveProcessor(new ArgumentParser((CoreCommands)new CoreProcessor(this.sieveRepository, this.usersRepository, (SieveParser)new Parser(new ConfigurationManager()))));
    }

    public void afterTest() throws Exception {
    }

    protected abstract SieveRepository createSieveRepository() throws Exception;

    protected abstract UsersRepository createUsersRepository();

    public boolean addUser(Username username, String password) throws Exception {
        this.usersRepository.addUser(username, password);
        return true;
    }

    @Override
    public void setMaxQuota(String user, long value) throws Exception {
        this.sieveRepository.setQuota(Username.of((String)user), QuotaSizeLimit.size((long)value));
    }

    public Session newSession(Continuation continuation) {
        return new ManageSieveSession(this.processor, continuation);
    }
}

