/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.managesieve.cassandra.host;

import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.mpt.host.JamesManageSieveHostSystem;
import org.apache.james.sieve.cassandra.CassandraActiveScriptDAO;
import org.apache.james.sieve.cassandra.CassandraSieveDAO;
import org.apache.james.sieve.cassandra.CassandraSieveQuotaDAO;
import org.apache.james.sieve.cassandra.CassandraSieveRepository;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.cassandra.CassandraUsersDAO;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.UsersRepositoryImpl;

public class CassandraHostSystem
extends JamesManageSieveHostSystem {
    private static final DomainList NO_DOMAIN_LIST = null;
    private final CassandraCluster cassandra;

    public CassandraHostSystem(CassandraCluster cassandra) {
        this.cassandra = cassandra;
    }

    protected SieveRepository createSieveRepository() {
        return new CassandraSieveRepository(new CassandraSieveDAO((CqlSession)this.cassandra.getConf()), new CassandraSieveQuotaDAO((CqlSession)this.cassandra.getConf()), new CassandraActiveScriptDAO((CqlSession)this.cassandra.getConf()));
    }

    protected UsersRepository createUsersRepository() {
        CassandraUsersDAO usersDAO = new CassandraUsersDAO((CqlSession)this.cassandra.getConf());
        UsersRepositoryImpl usersRepository = new UsersRepositoryImpl(NO_DOMAIN_LIST, (UsersDAO)usersDAO);
        usersRepository.setEnableVirtualHosting(false);
        return usersRepository;
    }
}

