/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.elasticsearch.host;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.opensearch.DockerOpenSearch;
import org.apache.james.backends.opensearch.DockerOpenSearchSingleton;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.events.EventBus;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.MailboxIdRoutingKeyFactory;
import org.apache.james.mailbox.opensearch.MailboxIndexCreationUtil;
import org.apache.james.mailbox.opensearch.MailboxOpenSearchConstants;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.mailbox.opensearch.events.OpenSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.opensearch.json.MessageToOpenSearchJson;
import org.apache.james.mailbox.opensearch.query.CriterionConverter;
import org.apache.james.mailbox.opensearch.query.QueryConverter;
import org.apache.james.mailbox.opensearch.search.OpenSearchSearcher;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.logger.DefaultMetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;

public class OpenSearchHostSystem
extends JamesImapHostSystem {
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT, ImapFeatures.Feature.MOD_SEQ_SEARCH});
    private DockerOpenSearch dockerOpenSearch;
    private StoreMailboxManager mailboxManager;
    private ReactorOpenSearchClient client;

    public void beforeTest() throws Exception {
        super.beforeTest();
        this.dockerOpenSearch = DockerOpenSearchSingleton.INSTANCE;
        this.dockerOpenSearch.start();
        this.initFields();
    }

    public void afterTest() throws IOException {
        this.client.close();
        this.dockerOpenSearch.cleanUpData();
    }

    private void initFields() throws Exception {
        this.client = MailboxIndexCreationUtil.prepareDefaultClient((ReactorOpenSearchClient)this.dockerOpenSearch.clientProvider().get(), (OpenSearchConfiguration)OpenSearchConfiguration.builder().addHost(this.dockerOpenSearch.getHttpHost()).build());
        InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
        MailboxIdRoutingKeyFactory routingKeyFactory = new MailboxIdRoutingKeyFactory();
        InMemoryIntegrationResources resources = InMemoryIntegrationResources.builder().authenticator(this.authenticator).authorizator(this.authorizator).inVmEventBus().defaultAnnotationLimits().defaultMessageParser().listeningSearchIndex(preInstanciationStage -> new OpenSearchListeningMessageSearchIndex((MailboxSessionMapperFactory)preInstanciationStage.getMapperFactory(), (Set)ImmutableSet.of(), new OpenSearchIndexer(this.client, MailboxOpenSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS), new OpenSearchSearcher(this.client, new QueryConverter(new CriterionConverter()), 100, MailboxOpenSearchConstants.DEFAULT_MAILBOX_READ_ALIAS, (RoutingKey.Factory)routingKeyFactory), new MessageToOpenSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"), IndexAttachments.YES, IndexHeaders.YES), preInstanciationStage.getSessionProvider(), (RoutingKey.Factory)routingKeyFactory, (MessageId.Factory)messageIdFactory, OpenSearchMailboxConfiguration.builder().build(), (MetricFactory)new RecordingMetricFactory())).noPreDeletionHooks().storeQuotaManager().build();
        this.mailboxManager = resources.getMailboxManager();
        ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (EventBus)resources.getMailboxManager().getEventBus(), (SubscriptionManager)new StoreSubscriptionManager((SubscriptionMapperFactory)this.mailboxManager.getMapperFactory(), this.mailboxManager.getMapperFactory(), this.mailboxManager.getEventBus()), (QuotaManager)new NoQuotaManager(), (QuotaRootResolver)resources.getDefaultUserQuotaRootResolver(), (MetricFactory)new DefaultMetricFactory());
        this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }

    public void setQuotaLimits(QuotaCountLimit maxMessageQuota, QuotaSizeLimit maxStorageQuota) {
        throw new NotImplementedException("not implemented");
    }

    protected void await() {
        this.dockerOpenSearch.flushIndices();
    }
}

