/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.script;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.james.core.Username;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.HostSystem;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.protocol.FileProtocolSessionBuilder;
import org.apache.james.mpt.protocol.ProtocolSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSimpleScriptedTestProtocol<T extends HostSystem, SelfT extends GenericSimpleScriptedTestProtocol<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericSimpleScriptedTestProtocol.class);
    private final FileProtocolSessionBuilder builder = new FileProtocolSessionBuilder();
    private final String scriptDirectory;
    private ProtocolSession preElements = new ProtocolSession();
    private ProtocolSession testElements = new ProtocolSession();
    private ProtocolSession postElements = new ProtocolSession();
    private final T hostSystem;
    private final List<PrepareCommand<? super T>> prepareCommands;
    private Locale locale;

    public GenericSimpleScriptedTestProtocol(String scriptDirectory, T hostSystem) throws Exception {
        this.scriptDirectory = scriptDirectory;
        this.hostSystem = hostSystem;
        this.locale = Locale.getDefault();
        this.prepareCommands = new ArrayList<PrepareCommand<? super T>>();
    }

    public SelfT withLocale(Locale locale) {
        this.locale = locale;
        return (SelfT)this;
    }

    public SelfT withUser(String user, String password) {
        return this.withUser(Username.of((String)user), password);
    }

    public SelfT withUser(Username username, String password) {
        this.prepareCommands.add(new CreateUser(username, password));
        return (SelfT)this;
    }

    public SelfT withPreparedCommand(PrepareCommand<? super T> command) {
        this.prepareCommands.add(command);
        return (SelfT)this;
    }

    public ProtocolSession preElements() {
        return this.preElements;
    }

    public ProtocolSession testElements() {
        return this.testElements;
    }

    public ProtocolSession postElements() {
        return this.postElements;
    }

    public void run(String fileName) throws Exception {
        this.prepare();
        Locale previousLocale = Locale.getDefault();
        try {
            Locale.setDefault(this.locale);
            this.addTestFile(fileName + ".test", this.testElements);
            this.runSessions((HostSystem)this.hostSystem);
        }
        finally {
            Locale.setDefault(previousLocale);
        }
    }

    private void prepare() throws Exception {
        for (PrepareCommand<T> cmd : this.prepareCommands) {
            cmd.prepare(this.hostSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSessions(HostSystem hostSystem) throws Exception {
        class SessionContinuation
        implements Continuation {
            public ProtocolSession session;

            SessionContinuation() {
            }

            @Override
            public void doContinue() {
                if (this.session != null) {
                    this.session.doContinue();
                }
            }
        }
        SessionContinuation continuation = new SessionContinuation();
        Session[] sessions = new Session[this.testElements.getSessionCount()];
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i] = hostSystem.newSession(continuation);
            sessions[i].start();
        }
        try {
            continuation.session = this.preElements;
            this.preElements.runSessions(sessions);
            continuation.session = this.testElements;
            this.testElements.runSessions(sessions);
            continuation.session = this.postElements;
            this.postElements.runSessions(sessions);
        }
        finally {
            for (Session session : sessions) {
                session.stop();
            }
        }
    }

    public void addTestFile(String fileName, ProtocolSession session) throws Exception {
        fileName = this.scriptDirectory + (String)fileName;
        try (InputStream is = this.getClass().getResourceAsStream((String)fileName);){
            if (is == null) {
                throw new Exception("Test Resource '" + (String)fileName + "' not found.");
            }
            this.builder.addProtocolLinesFromStream(is, session, (String)fileName);
        }
    }

    private static class CreateUser
    implements PrepareCommand<HostSystem> {
        final Username username;
        final String password;

        CreateUser(Username username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void prepare(HostSystem system) throws Exception {
            try {
                system.addUser(this.username, this.password);
            }
            catch (Exception e) {
                LOGGER.info("User {} already exists", (Object)this.username, (Object)e);
            }
        }
    }

    public static interface PrepareCommand<T extends HostSystem> {
        public void prepare(T var1) throws Exception;
    }
}

