/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.protocol;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.james.mpt.api.ProtocolInteractor;
import org.apache.james.mpt.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolSession
implements ProtocolInteractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolSession.class);
    private boolean continued = false;
    private boolean continuationExpected = false;
    private int maxSessionNumber;
    protected List<ProtocolElement> testElements = new ArrayList<ProtocolElement>();
    private Iterator<ProtocolElement> elementsIterator;
    private Session[] sessions;
    private ProtocolElement nextTest;
    private boolean continueAfterFailure = false;
    private Map<String, Stopwatch> timers = new HashMap<String, Stopwatch>();

    public final boolean isContinueAfterFailure() {
        return this.continueAfterFailure;
    }

    public final void setContinueAfterFailure(boolean continueAfterFailure) {
        this.continueAfterFailure = continueAfterFailure;
    }

    public int getSessionCount() {
        return this.maxSessionNumber + 1;
    }

    public void runSessions(Session[] sessions) throws Exception {
        this.sessions = sessions;
        for (ProtocolElement obj : this.testElements) {
            if (!(obj instanceof ProtocolElement)) continue;
            ProtocolElement test = obj;
            test.testProtocol(sessions, this.continueAfterFailure);
        }
    }

    public void doContinue() {
        block5: {
            try {
                if (this.continuationExpected) {
                    this.continued = true;
                    while (this.elementsIterator.hasNext()) {
                        ProtocolElement obj = this.elementsIterator.next();
                        if (!(obj instanceof ProtocolElement)) continue;
                        this.nextTest = obj;
                        if (!this.nextTest.isClient()) break;
                        this.nextTest.testProtocol(this.sessions, this.continueAfterFailure);
                    }
                    if (!this.elementsIterator.hasNext()) {
                        this.nextTest = null;
                    }
                    break block5;
                }
                throw new RuntimeException("Unexpected continuation");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void cl(String clientLine) {
        this.testElements.add(new ClientRequest(clientLine));
    }

    @Override
    public void sl(String serverLine, String location) {
        this.testElements.add(new ServerResponse(serverLine, location));
    }

    @Override
    public void sub(List<String> serverLines, String location) {
        this.testElements.add(new ServerUnorderedBlockResponse(serverLines, location));
    }

    @Override
    public void cl(int sessionNumber, String clientLine) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new ClientRequest(sessionNumber, clientLine));
    }

    @Override
    public void cont(int sessionNumber) throws Exception {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new ContinuationElement(sessionNumber));
    }

    @Override
    public void sl(int sessionNumber, String serverLine, String location, String lastClientMessage) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new ServerResponse(sessionNumber, serverLine, location, lastClientMessage));
    }

    @Override
    public void sub(int sessionNumber, List<String> serverLines, String location, String lastClientMessage) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new ServerUnorderedBlockResponse(sessionNumber, serverLines, location, lastClientMessage));
    }

    public void wait(int sessionNumber, long timeToWaitInMs) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new WaitElement(timeToWaitInMs));
    }

    public void log(int sessionNumber, LolLevel level, String message) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new LogElement(level, message));
    }

    public void reinit(int sessionNumber) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new ReinitElement(sessionNumber));
    }

    public void await(int sessionNumber) {
        this.maxSessionNumber = Math.max(this.maxSessionNumber, sessionNumber);
        this.testElements.add(new AwaitElement(sessionNumber));
    }

    public void timer(TimerCommand timerCommand, String timerName) {
        this.testElements.add(new TimerElement(timerCommand, timerName));
    }

    private void handleFailure(boolean continueAfterFailure, String message) throws InvalidServerResponseException {
        if (!continueAfterFailure) {
            throw new InvalidServerResponseException(message);
        }
        LOGGER.warn(message);
    }

    public String toString() {
        String TAB = " ";
        String result = "ProtocolSession ( continued = " + this.continued + " continuationExpected = " + this.continuationExpected + " maxSessionNumber = " + this.maxSessionNumber + " testElements = " + this.testElements + " elementsIterator = " + this.elementsIterator + " sessions = " + Arrays.toString(this.sessions) + " nextTest = " + this.nextTest + " continueAfterFailure = " + this.continueAfterFailure + "  )";
        return result;
    }

    private static interface ProtocolElement {
        public void testProtocol(Session[] var1, boolean var2) throws Exception;

        public boolean isClient();
    }

    private static class ClientRequest
    implements ProtocolElement {
        private final int sessionNumber;
        private final String message;

        public ClientRequest(String message) {
            this(-1, message);
        }

        public ClientRequest(int sessionNumber, String message) {
            this.sessionNumber = sessionNumber;
            this.message = message;
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            if (this.sessionNumber < 0) {
                for (Session session : sessions) {
                    this.writeMessage(session);
                }
            } else {
                Session session = sessions[this.sessionNumber];
                this.writeMessage(session);
            }
        }

        private void writeMessage(Session session) throws Exception {
            LOGGER.debug("C: {}", (Object)this.message);
            session.writeLine(this.message);
        }

        @Override
        public boolean isClient() {
            return true;
        }
    }

    private class ServerResponse
    implements ProtocolElement {
        private final String lastClientMessage;
        private final int sessionNumber;
        private final String expectedLine;
        protected String location;

        public ServerResponse(String expectedPattern, String location) {
            this(-1, expectedPattern, location, null);
        }

        public ServerResponse(int sessionNumber, String expectedPattern, String location, String lastClientMessage) {
            this.sessionNumber = sessionNumber;
            this.expectedLine = expectedPattern;
            this.location = location;
            this.lastClientMessage = lastClientMessage;
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            if (this.sessionNumber < 0) {
                for (Session session : sessions) {
                    this.checkResponse(session, continueAfterFailure);
                }
            } else {
                Session session = sessions[this.sessionNumber];
                this.checkResponse(session, continueAfterFailure);
            }
        }

        protected void checkResponse(Session session, boolean continueAfterFailure) throws Exception {
            String testLine = this.readLine(session);
            LOGGER.debug("S: {}", (Object)testLine);
            if (!this.match(this.expectedLine, testLine)) {
                String errMsg = "\nLocation: " + this.location + "\nLastClientMsg: " + this.lastClientMessage + "\nExpected: '" + this.expectedLine + "'\nActual   : '" + testLine + "'";
                ProtocolSession.this.handleFailure(continueAfterFailure, errMsg);
            }
        }

        protected boolean match(String expected, String actual) {
            return Pattern.matches(expected, actual);
        }

        protected String readLine(Session session) throws Exception {
            try {
                return session.readLine();
            }
            catch (IOException e) {
                String errMsg = "\nLocation: " + this.location + "\nExpected: " + this.expectedLine + "\nReason: Server Timeout.";
                throw new InvalidServerResponseException(errMsg);
            }
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    private class ServerUnorderedBlockResponse
    extends ServerResponse {
        private List<String> expectedLines;

        public ServerUnorderedBlockResponse(List<String> expectedLines, String location) {
            this(-1, expectedLines, location, null);
        }

        public ServerUnorderedBlockResponse(int sessionNumber, List<String> expectedLines, String location, String lastClientMessage) {
            super(sessionNumber, "<Unordered Block>", location, lastClientMessage);
            this.expectedLines = new ArrayList<String>();
            this.expectedLines = expectedLines;
        }

        @Override
        protected void checkResponse(Session session, boolean continueAfterFailure) throws Exception {
            ArrayList<String> testLines = new ArrayList<String>(this.expectedLines);
            while (testLines.size() > 0) {
                String actualLine = this.readLine(session);
                boolean foundMatch = false;
                for (int i = 0; i < testLines.size(); ++i) {
                    String expected = (String)testLines.get(i);
                    if (!this.match(expected, actualLine)) continue;
                    foundMatch = true;
                    testLines.remove(expected);
                    break;
                }
                if (foundMatch) continue;
                StringBuilder errMsg = new StringBuilder().append("\nLocation: ").append(this.location).append("\nExpected one of: ");
                for (String expectedLine : this.expectedLines) {
                    errMsg.append("\n    ");
                    errMsg.append(expectedLine);
                }
                errMsg.append("\nActual: ").append(actualLine);
                ProtocolSession.this.handleFailure(continueAfterFailure, errMsg.toString());
            }
        }
    }

    private class ContinuationElement
    implements ProtocolElement {
        private final int sessionNumber;

        public ContinuationElement(int sessionNumber) throws Exception {
            this.sessionNumber = Math.max(0, sessionNumber);
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            Session session = sessions[this.sessionNumber];
            ProtocolSession.this.continuationExpected = true;
            ProtocolSession.this.continued = false;
            String testLine = session.readLine();
            if (!testLine.startsWith("+") || !ProtocolSession.this.continued) {
                String message = String.format("Expected continuation, got '%s'", testLine);
                ProtocolSession.this.handleFailure(continueAfterFailure, message);
            }
            ProtocolSession.this.continuationExpected = false;
            ProtocolSession.this.continued = false;
            if (ProtocolSession.this.nextTest != null) {
                ProtocolSession.this.nextTest.testProtocol(sessions, continueAfterFailure);
            }
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    private static class WaitElement
    implements ProtocolElement {
        private final long timeToWaitInMs;

        public WaitElement(long timeToWaitInMs) {
            this.timeToWaitInMs = timeToWaitInMs;
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            Thread.sleep(this.timeToWaitInMs);
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    private static class LogElement
    implements ProtocolElement {
        private final LolLevel level;
        private final String message;

        public LogElement(LolLevel level, String message) {
            this.level = level;
            this.message = message;
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            switch (this.level) {
                case Debug: {
                    LOGGER.debug(this.message);
                    break;
                }
                case Info: {
                    LOGGER.info(this.message);
                    break;
                }
                case Warn: {
                    LOGGER.warn(this.message);
                    break;
                }
                case Err: {
                    LOGGER.error(this.message);
                }
            }
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    static enum LolLevel {
        Debug,
        Info,
        Warn,
        Err;

    }

    private static class ReinitElement
    implements ProtocolElement {
        private final int sessionNumber;

        public ReinitElement(int sessionNumber) {
            this.sessionNumber = Math.max(0, sessionNumber);
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            Session session = sessions[this.sessionNumber];
            session.restart();
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    private static class AwaitElement
    implements ProtocolElement {
        private final int sessionNumber;

        private AwaitElement(int sessionNumber) {
            this.sessionNumber = Math.max(0, sessionNumber);
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            sessions[this.sessionNumber].await();
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    private class TimerElement
    implements ProtocolElement {
        private TimerCommand timerCommand;
        private String timerName;

        public TimerElement(TimerCommand timerCommand, String timerName) {
            this.timerCommand = timerCommand;
            this.timerName = timerName;
        }

        @Override
        public void testProtocol(Session[] sessions, boolean continueAfterFailure) throws Exception {
            switch (this.timerCommand) {
                case START: {
                    this.start();
                    break;
                }
                case PRINT: {
                    this.print();
                    break;
                }
                case RESET: {
                    this.reset();
                    break;
                }
                default: {
                    throw new InvalidServerResponseException("Invalid TIMER command '" + this.timerCommand + "' for timer name: '" + this.timerName + "'");
                }
            }
        }

        private void start() {
            ProtocolSession.this.timers.put(this.timerName, Stopwatch.createStarted());
        }

        private void print() throws InvalidServerResponseException {
            Stopwatch stopwatch = ProtocolSession.this.timers.get(this.timerName);
            if (stopwatch == null) {
                throw new InvalidServerResponseException("TIMER '" + this.timerName + "' undefined");
            }
            LOGGER.info("Time spent in '{}': {} ms", (Object)this.timerName, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }

        private void reset() throws InvalidServerResponseException {
            Stopwatch stopwatch = ProtocolSession.this.timers.get(this.timerName);
            if (stopwatch == null) {
                throw new InvalidServerResponseException("TIMER '" + this.timerName + "' undefined");
            }
            stopwatch.reset();
            stopwatch.start();
        }

        @Override
        public boolean isClient() {
            return false;
        }
    }

    protected static enum TimerCommand {
        START,
        PRINT,
        RESET;


        public static TimerCommand from(String value) throws InvalidServerResponseException {
            if (value.equalsIgnoreCase("start")) {
                return START;
            }
            if (value.equalsIgnoreCase("print")) {
                return PRINT;
            }
            if (value.equalsIgnoreCase("reset")) {
                return RESET;
            }
            throw new InvalidServerResponseException("Invalid TIMER command '" + value + "'");
        }
    }

    public static class InvalidServerResponseException
    extends Exception {
        public InvalidServerResponseException(String message) {
            super(message);
        }
    }
}

