/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.host;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.session.ExternalSessionFactory;
import org.apache.james.util.Port;

public class ExternalHostSystem
extends ExternalSessionFactory
implements ImapHostSystem {
    private final UserAdder userAdder;
    private final ImapFeatures features;

    public ExternalHostSystem(ImapFeatures features, String host, Port port, Monitor monitor, String shabang, UserAdder userAdder) {
        super(host, port, monitor, shabang);
        this.features = features;
        this.userAdder = userAdder;
    }

    public ExternalHostSystem(ImapFeatures features, Monitor monitor, String shabang, UserAdder userAdder) {
        super(monitor, shabang);
        this.features = features;
        this.userAdder = userAdder;
    }

    @Override
    public boolean addUser(Username user, String password) throws Exception {
        if (this.userAdder == null) {
            this.monitor.note("Please ensure user '" + String.valueOf(user) + "' with password '" + password + "' exists.");
            return false;
        }
        this.userAdder.addUser(user, password);
        return true;
    }

    @Override
    public void createMailbox(MailboxPath mailboxPath) throws Exception {
        throw new NotImplementedException("Not implemented");
    }

    public void beforeTests() throws Exception {
    }

    public void afterTests() throws Exception {
    }

    @Override
    public void beforeTest() throws Exception {
    }

    @Override
    public void afterTest() throws Exception {
    }

    @Override
    public boolean supports(ImapFeatures.Feature ... features) {
        return this.features.supports(features);
    }

    @Override
    public void setQuotaLimits(QuotaCountLimit maxMessageQuota, QuotaSizeLimit maxStorageQuota) throws Exception {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public void grantRights(MailboxPath mailboxPath, Username userName, MailboxACL.Rfc4314Rights rights) throws Exception {
        throw new NotImplementedException("Not implemented");
    }
}

