/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.ProtocolInteractor;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.api.SessionFactory;
import org.apache.james.mpt.protocol.ProtocolSession;

public class Runner {
    private final ProtocolSession preElements = new ProtocolSession();
    private final ProtocolSession testElements = new ProtocolSession();
    private final ProtocolSession postElements = new ProtocolSession();

    public void continueAfterFailure() {
        this.preElements.setContinueAfterFailure(true);
        this.testElements.setContinueAfterFailure(true);
        this.postElements.setContinueAfterFailure(true);
    }

    public ProtocolInteractor getPostElements() {
        return this.postElements;
    }

    public ProtocolInteractor getPreElements() {
        return this.preElements;
    }

    public ProtocolInteractor getTestElements() {
        return this.testElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSessions(SessionFactory factory) throws Exception {
        class SessionContinuation
        implements Continuation {
            public ProtocolSession session;

            SessionContinuation(Runner this$0) {
            }

            @Override
            public void doContinue() {
                if (this.session != null) {
                    this.session.doContinue();
                }
            }
        }
        SessionContinuation continuation = new SessionContinuation(this);
        Session[] sessions = new Session[this.testElements.getSessionCount()];
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i] = factory.newSession(continuation);
            sessions[i].start();
        }
        try {
            continuation.session = this.preElements;
            this.preElements.runSessions(sessions);
            continuation.session = this.testElements;
            this.testElements.runSessions(sessions);
            continuation.session = this.postElements;
            this.postElements.runSessions(sessions);
        }
        finally {
            for (Session session : sessions) {
                session.stop();
            }
        }
    }

    public String toString() {
        String TAB = " ";
        return "Runner ( preElements = " + String.valueOf(this.preElements) + " testElements = " + String.valueOf(this.testElements) + " postElements = " + String.valueOf(this.postElements) + "  )";
    }
}

