/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.api;

import java.util.Collection;
import org.apache.james.mpt.api.ImapFeatures;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImapFeaturesTest {
    @Test
    void supportedFeaturesShouldReturnEmptySetWhenNoFeatures() {
        Assertions.assertThat((Collection)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supportedFeatures()).isEmpty();
    }

    @Test
    void supportedFeaturesShouldReturnNamespaceInSetWhenNamespaceSupported() {
        Assertions.assertThat((Collection)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supportedFeatures()).containsExactly((Object[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    }

    @Test
    void supportsShouldReturnFalseOnNamespaceWhenNamespaceIsNotSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports(new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT})).isFalse();
    }

    @Test
    void supportsShouldReturnTrueOnNamespaceWhenNamespaceIsSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supports(new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT})).isTrue();
    }

    @Test
    void supportsShouldReturnTrueOnDuplicateNamespaceEntryWhenNamespaceIsSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supports(new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT, ImapFeatures.Feature.NAMESPACE_SUPPORT})).isTrue();
    }

    @Test
    void supportsShouldReturnTrueOnEmptyListWhenNamespaceIsSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supports(new ImapFeatures.Feature[0])).isTrue();
    }

    @Test
    void supportsShouldReturnTrueOnEmptyListWhenNoFeatures() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports(new ImapFeatures.Feature[0])).isTrue();
    }

    @Test
    void supportsShouldThrowOnNullFeature() {
        Assertions.assertThatThrownBy(() -> ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports(new ImapFeatures.Feature[]{null})).isInstanceOf(NullPointerException.class);
    }

    @Test
    void supportsShouldThrowOnNullFeatureArray() {
        Assertions.assertThatThrownBy(() -> ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports((ImapFeatures.Feature[])null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void ofShouldThrowOnNullFeature() {
        Assertions.assertThatThrownBy(() -> ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{null})).isInstanceOf(NullPointerException.class);
    }

    @Test
    void ofShouldThrowOnNullFeatureArray() {
        Assertions.assertThatThrownBy(() -> ImapFeatures.of((ImapFeatures.Feature[])null)).isInstanceOf(NullPointerException.class);
    }
}

