/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import org.apache.james.core.Username;
import org.apache.james.mpt.DiscardProtocol;
import org.apache.james.mpt.user.ScriptedUserAdder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestScriptedUserAdder {
    DiscardProtocol protocol;
    DiscardProtocol.Record record;

    TestScriptedUserAdder() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.protocol = new DiscardProtocol();
        this.protocol.start();
        this.record = this.protocol.recordNext();
    }

    @AfterEach
    void tearDown() {
        this.protocol.stop();
    }

    @Test
    void testShouldExecuteScriptAgainstPort() throws Exception {
        ScriptedUserAdder adder = new ScriptedUserAdder("localhost", this.protocol.getPort(), "C: USER='${user}' password='${password}'");
        adder.addUser(Username.of((String)"user"), "Some Password");
        Assertions.assertThat((String)this.record.complete()).isEqualTo("USER='user' password='Some Password'\r\n");
    }
}

