/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import java.io.Reader;
import java.io.StringReader;
import org.apache.james.mpt.api.ProtocolInteractor;
import org.apache.james.mpt.protocol.ProtocolSessionBuilder;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestFileProtocolSessionBuilder {
    static final String SCRIPT_WITH_VARIABLES = "HELLO ${not} ${foo} WORLD ${bar}";
    static final String SCRIPT_WITH_FOO_REPLACED_BY_WHATEVER = "HELLO ${not} whatever WORLD ${bar}";
    static final String SCRIPT_WITH_VARIABLES_INLINED = "HELLO not foo WORLD bar";
    ProtocolSessionBuilder builder;
    ProtocolInteractor session;

    TestFileProtocolSessionBuilder() {
    }

    @BeforeEach
    void setUp() {
        this.builder = new ProtocolSessionBuilder();
        this.session = (ProtocolInteractor)Mockito.mock(ProtocolInteractor.class);
    }

    @Test
    void testShouldPreserveContentsWhenNoVariablesSet() throws Exception {
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: HELLO ${not} ${foo} WORLD ${bar}"), this.session);
        ((ProtocolInteractor)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).cl(-1, SCRIPT_WITH_VARIABLES);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
    }

    @Test
    void testShouldReplaceVariableWhenSet() throws Exception {
        this.builder.setVariable("foo", "whatever");
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: HELLO ${not} ${foo} WORLD ${bar}"), this.session);
        ((ProtocolInteractor)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).cl(-1, SCRIPT_WITH_FOO_REPLACED_BY_WHATEVER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
    }

    @Test
    void testShouldReplaceAllVariablesWhenSet() throws Exception {
        this.builder.setVariable("bar", "bar");
        this.builder.setVariable("foo", "foo");
        this.builder.setVariable("not", "not");
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: HELLO ${not} ${foo} WORLD ${bar}"), this.session);
        ((ProtocolInteractor)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).cl(-1, SCRIPT_WITH_VARIABLES_INLINED);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
    }

    @Test
    void testShouldReplaceVariableAtBeginningAndEnd() throws Exception {
        this.builder.setVariable("foo", "whatever");
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: ${foo} Some Other Script${foo}${foo}"), this.session);
        ((ProtocolInteractor)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).cl(-1, "whatever Some Other Scriptwhateverwhatever");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
    }

    @Test
    void testShouldIgnoreNotQuiteVariables() throws Exception {
        String NEARLY = "{foo}${}${foo Some Other Script${foo}";
        this.builder.setVariable("foo", "whatever");
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: {foo}${}${foo Some Other Script${foo}"), this.session);
        ((ProtocolInteractor)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).cl(-1, "{foo}${}${foo Some Other Script${foo}");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
    }
}

