/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import org.apache.james.core.Username;
import org.apache.james.mpt.DiscardProtocol;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.monitor.NullMonitor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestExternalHostSystem {
    static final Username USER = Username.of((String)"USERNAME");
    static final String PASSWORD = "SOME PASSWORD";
    static final String SHABANG = "This Is The Shabang";
    static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    DiscardProtocol protocol;
    DiscardProtocol.Record record;
    Continuation continuation;
    UserAdder userAdder;

    TestExternalHostSystem() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.protocol = new DiscardProtocol();
        this.protocol.start();
        this.record = this.protocol.recordNext();
        this.continuation = (Continuation)Mockito.mock(Continuation.class);
        this.userAdder = (UserAdder)Mockito.mock(UserAdder.class);
    }

    @AfterEach
    void tearDown() {
        this.protocol.stop();
    }

    @Test
    void testWrite() throws Exception {
        Session session = this.newSession(SHABANG);
        String in = "Hello, World";
        session.writeLine("Hello, World");
        session.stop();
        Assertions.assertThat((String)this.record.complete()).isEqualTo("Hello, World\r\n");
    }

    @Test
    void testAddUser() throws Exception {
        ExternalHostSystem system = this.buildSystem(SHABANG);
        system.addUser(USER, PASSWORD);
        ((UserAdder)Mockito.verify((Object)this.userAdder, (VerificationMode)Mockito.times((int)1))).addUser(USER, PASSWORD);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.userAdder});
    }

    private Session newSession(String shabang) throws Exception {
        ExternalHostSystem system = this.buildSystem(shabang);
        return system.newSession(this.continuation);
    }

    private ExternalHostSystem buildSystem(String shabang) {
        return new ExternalHostSystem(SUPPORTED_FEATURES, "localhost", this.protocol.getPort(), (Monitor)new NullMonitor(), shabang, this.userAdder);
    }
}

