/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.user;

import java.io.Reader;
import java.io.StringReader;
import org.apache.james.core.Username;
import org.apache.james.mpt.Runner;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.monitor.NullMonitor;
import org.apache.james.mpt.protocol.ProtocolSessionBuilder;
import org.apache.james.mpt.session.ExternalSessionFactory;
import org.apache.james.util.Port;

public class ScriptedUserAdder
implements UserAdder {
    private static final String SCRIPT_NAME = "Add User Script";
    private static final String PASSWORD_VARIABLE_NAME = "password";
    private static final String USER_VARIABLE_NAME = "user";
    private final String host;
    private final Port port;
    private final String script;
    private final Monitor monitor;

    public ScriptedUserAdder(String host, Port port) {
        this(host, port, (String)null);
    }

    public ScriptedUserAdder(String host, Port port, String script) {
        this(host, port, script, new NullMonitor());
    }

    public ScriptedUserAdder(String host, Port port, Monitor monitor) {
        this(host, port, null, monitor);
    }

    public ScriptedUserAdder(String host, Port port, String script, Monitor monitor) {
        this.host = host;
        this.port = port;
        this.script = script;
        this.monitor = monitor;
    }

    @Override
    public void addUser(Username user, String password) throws Exception {
        StringReader reader = new StringReader(this.script);
        this.addUser(user, password, reader);
    }

    public void addUser(Username user, String password, Reader reader) throws Exception {
        ProtocolSessionBuilder builder = new ProtocolSessionBuilder();
        builder.setVariable(USER_VARIABLE_NAME, user.asString());
        builder.setVariable(PASSWORD_VARIABLE_NAME, password);
        Runner runner = new Runner();
        builder.addProtocolLines(SCRIPT_NAME, reader, runner.getTestElements());
        ExternalSessionFactory factory = new ExternalSessionFactory(this.host, this.port, this.monitor, null);
        runner.runSessions(factory);
    }

    public String toString() {
        String TAB = " ";
        return "ScriptedUserAdder ( " + super.toString() + " host = " + this.host + " port = " + this.port + " script = " + this.script + " monitor = " + this.monitor + "  )";
    }
}

