/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class ScriptBuilder {
    private int tagCount = 0;
    private boolean uidSearch = false;
    private boolean peek = false;
    private int messageNumber = 1;
    private String user = "imapuser";
    private String password = "password";
    private String mailbox = "testmailbox";
    private String file = "rfc822.mail";
    private String basedir = "/org/apache/james/imap/samples/";
    private boolean createdMailbox = false;
    private final Client client;
    private Fetch fetch = new Fetch();
    private Search search = new Search();
    private String partialFetch = "";

    public static ScriptBuilder open(String host, int port) throws Exception {
        InetSocketAddress address = new InetSocketAddress(host, port);
        SocketChannel socket = SocketChannel.open(address);
        socket.configureBlocking(false);
        Client client = new Client(socket, socket);
        return new ScriptBuilder(client);
    }

    public ScriptBuilder(Client client) {
        this.client = client;
    }

    public final boolean isPeek() {
        return this.peek;
    }

    public final void setPeek(boolean peek) {
        this.peek = peek;
    }

    public final boolean isUidSearch() {
        return this.uidSearch;
    }

    public final void setUidSearch(boolean uidSearch) {
        this.uidSearch = uidSearch;
    }

    public final String getBasedir() {
        return this.basedir;
    }

    public final void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public final String getFile() {
        return this.file;
    }

    public final void setFile(String file) {
        this.file = file;
    }

    private InputStream openFile() throws Exception {
        InputStream result = this.getClass().getResourceAsStream(this.basedir + this.file);
        return new IgnoreHeaderInputStream(result);
    }

    public final Fetch getFetch() {
        return this.fetch;
    }

    public final void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public final Fetch resetFetch() {
        this.fetch = new Fetch();
        return this.fetch;
    }

    public final int getMessageNumber() {
        return this.messageNumber;
    }

    public final void setMessageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
    }

    public final String getMailbox() {
        return this.mailbox;
    }

    public final ScriptBuilder setMailbox(String mailbox) {
        this.mailbox = mailbox;
        return this;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public void login() throws Exception {
        this.command("LOGIN " + this.user + " " + this.password);
    }

    private void command(String command) throws Exception {
        this.tag();
        this.write(command);
        this.lineEnd();
        this.response();
    }

    public ScriptBuilder rename(String to) throws Exception {
        return this.rename(this.getMailbox(), to);
    }

    public ScriptBuilder rename(String from, String to) throws Exception {
        this.command("RENAME " + from + " " + to);
        return this;
    }

    public ScriptBuilder select() throws Exception {
        this.command("SELECT " + this.mailbox);
        return this;
    }

    public ScriptBuilder create() throws Exception {
        this.command("CREATE " + this.mailbox);
        this.createdMailbox = true;
        return this;
    }

    public ScriptBuilder flagDeleted() throws Exception {
        return this.flagDeleted(this.messageNumber);
    }

    public ScriptBuilder flagDeleted(int messageNumber) throws Exception {
        this.store(new Flags().deleted().msn(messageNumber));
        return this;
    }

    public ScriptBuilder expunge() throws Exception {
        this.command("EXPUNGE");
        return this;
    }

    public void delete() throws Exception {
        if (this.createdMailbox) {
            this.command("DELETE " + this.mailbox);
        }
    }

    public void search() throws Exception {
        this.search.setUidSearch(this.uidSearch);
        this.command(this.search.command());
        this.search = new Search();
    }

    public ScriptBuilder all() {
        this.search.all();
        return this;
    }

    public ScriptBuilder answered() {
        this.search.answered();
        return this;
    }

    public ScriptBuilder bcc(String address) {
        this.search.bcc(address);
        return this;
    }

    public ScriptBuilder before(int year, int month, int day) {
        this.search.before(year, month, day);
        return this;
    }

    public ScriptBuilder body(String text) {
        this.search.body(text);
        return this;
    }

    public ScriptBuilder cc(String address) {
        this.search.cc(address);
        return this;
    }

    public ScriptBuilder deleted() {
        this.search.deleted();
        return this;
    }

    public ScriptBuilder draft() {
        this.search.draft();
        return this;
    }

    public ScriptBuilder flagged() {
        this.search.flagged();
        return this;
    }

    public ScriptBuilder from(String address) {
        this.search.from(address);
        return this;
    }

    public ScriptBuilder header(String field, String value) {
        this.search.header(field, value);
        return this;
    }

    public ScriptBuilder keyword(String flag) {
        this.search.keyword(flag);
        return this;
    }

    public ScriptBuilder larger(long size) {
        this.search.larger(size);
        return this;
    }

    public ScriptBuilder newOperator() {
        this.search.newOperator();
        return this;
    }

    public ScriptBuilder not() {
        this.search.not();
        return this;
    }

    public ScriptBuilder old() {
        this.search.old();
        return this;
    }

    public ScriptBuilder on(int year, int month, int day) {
        this.search.on(year, month, day);
        return this;
    }

    public ScriptBuilder or() {
        this.search.or();
        return this;
    }

    public ScriptBuilder recent() {
        this.search.recent();
        return this;
    }

    public ScriptBuilder seen() {
        this.search.seen();
        return this;
    }

    public ScriptBuilder sentbefore(int year, int month, int day) {
        this.search.sentbefore(year, month, day);
        return this;
    }

    public ScriptBuilder senton(int year, int month, int day) {
        this.search.senton(year, month, day);
        return this;
    }

    public ScriptBuilder sentsince(int year, int month, int day) {
        this.search.sentsince(year, month, day);
        return this;
    }

    public ScriptBuilder since(int year, int month, int day) {
        this.search.since(year, month, day);
        return this;
    }

    public ScriptBuilder smaller(int size) {
        this.search.smaller(size);
        return this;
    }

    public ScriptBuilder subject(String address) {
        this.search.subject(address);
        return this;
    }

    public ScriptBuilder text(String text) {
        this.search.text(text);
        return this;
    }

    public ScriptBuilder to(String address) {
        this.search.to(address);
        return this;
    }

    public ScriptBuilder uid() {
        this.search.uid();
        return this;
    }

    public ScriptBuilder unanswered() {
        this.search.unanswered();
        return this;
    }

    public ScriptBuilder undeleted() {
        this.search.undeleted();
        return this;
    }

    public ScriptBuilder undraft() {
        this.search.undraft();
        return this;
    }

    public ScriptBuilder unflagged() {
        this.search.unflagged();
        return this;
    }

    public ScriptBuilder unkeyword(String flag) {
        this.search.unkeyword(flag);
        return this;
    }

    public ScriptBuilder unseen() {
        this.search.unseen();
        return this;
    }

    public ScriptBuilder openParen() {
        this.search.openParen();
        return this;
    }

    public ScriptBuilder closeParen() {
        this.search.closeParen();
        return this;
    }

    public ScriptBuilder msn(int low, int high) {
        this.search.msn(low, high);
        return this;
    }

    public ScriptBuilder msnAndUp(int limit) {
        this.search.msnAndUp(limit);
        return this;
    }

    public ScriptBuilder msnAndDown(int limit) {
        this.search.msnAndDown(limit);
        return this;
    }

    public Flags flags() {
        return new Flags();
    }

    public void store(Flags flags) throws Exception {
        String command = flags.command();
        this.command(command);
    }

    public Search getSearch() throws Exception {
        return this.search;
    }

    public ScriptBuilder partial(long start, long octets) {
        this.partialFetch = "<" + start + "." + octets + ">";
        return this;
    }

    public ScriptBuilder fetchSection(String section) throws Exception {
        StringBuilder command = new StringBuilder("FETCH ");
        command.append(this.messageNumber);
        if (this.peek) {
            command.append(" (BODY.PEEK[");
        } else {
            command.append(" (BODY[");
        }
        command.append(section).append("]").append(this.partialFetch).append(")");
        this.command(command.toString());
        return this;
    }

    public void fetchAllMessages() throws Exception {
        String command = this.fetch.command();
        this.command(command);
    }

    public ScriptBuilder list() throws Exception {
        this.command("LIST \"\" \"*\"");
        return this;
    }

    public void fetchBody() throws Exception {
    }

    public void fetch() throws Exception {
        String command = this.fetch.command(this.messageNumber);
        this.command(command);
    }

    public void fetchFlags() throws Exception {
        String command = "FETCH " + this.messageNumber + " (FLAGS)";
        this.command(command);
    }

    public void append() throws Exception {
        this.tag();
        this.write("APPEND " + this.mailbox);
        this.write(this.openFile());
        this.lineEnd();
        this.response();
    }

    private void write(InputStream in) throws Exception {
        this.client.write(in);
    }

    private void response() throws Exception {
        this.client.readResponse();
    }

    private void tag() throws Exception {
        this.client.lineStart();
        this.write("A" + ++this.tagCount + " ");
    }

    private void lineEnd() throws Exception {
        this.client.lineEnd();
    }

    private void write(String phrase) throws Exception {
        this.client.write(phrase);
    }

    public void close() throws Exception {
        this.client.close();
    }

    public void logout() throws Exception {
        this.command("LOGOUT");
    }

    public void quit() throws Exception {
        this.delete();
        this.logout();
        this.close();
    }

    public static final class Client {
        private final Out out;
        private final ReadableByteChannel source;
        private final WritableByteChannel sump;
        private final ByteBuffer inBuffer = ByteBuffer.allocate(256);
        private final ByteBuffer outBuffer = ByteBuffer.allocate(262144);
        private final ByteBuffer crlf;
        private boolean isLineTagged = false;
        private int continuationBytes = 0;

        public Client(ReadableByteChannel source, WritableByteChannel sump) throws Exception {
            this.source = source;
            this.sump = sump;
            this.out = new Out();
            byte[] crlf = new byte[]{13, 10};
            this.crlf = ByteBuffer.wrap(crlf);
            this.inBuffer.flip();
            this.readLine();
        }

        public void write(InputStream in) throws Exception {
            this.outBuffer.clear();
            int next = in.read();
            while (next != -1) {
                if (next == 10) {
                    this.outBufferNext((byte)13);
                    this.outBufferNext((byte)10);
                } else if (next == 13) {
                    this.outBufferNext((byte)13);
                    this.outBufferNext((byte)10);
                    next = in.read();
                    if (next == 10) {
                        next = in.read();
                    } else if (next != -1) {
                        this.outBufferNext((byte)next);
                    }
                } else {
                    this.outBufferNext((byte)next);
                }
                next = in.read();
            }
            this.writeOutBuffer();
        }

        public void outBufferNext(byte next) throws Exception {
            this.outBuffer.put(next);
        }

        private void writeOutBuffer() throws Exception {
            this.outBuffer.flip();
            int count = this.outBuffer.limit();
            String continuation = " {" + count + "+}";
            this.write(continuation);
            this.lineEnd();
            this.out.client();
            while (this.outBuffer.hasRemaining()) {
                byte next = this.outBuffer.get();
                this.print(next);
                if (next != 10) continue;
                this.out.client();
            }
            this.outBuffer.rewind();
            while (this.outBuffer.hasRemaining()) {
                this.sump.write(this.outBuffer);
            }
        }

        public void readResponse() throws Exception {
            this.isLineTagged = false;
            while (!this.isLineTagged) {
                this.readLine();
            }
        }

        private byte next() throws Exception {
            byte result;
            if (this.inBuffer.hasRemaining()) {
                result = this.inBuffer.get();
                this.print(result);
            } else {
                this.inBuffer.compact();
                int i = 0;
                while ((i = this.source.read(this.inBuffer)) == 0) {
                }
                if (i == -1) {
                    throw new RuntimeException("Unexpected EOF");
                }
                this.inBuffer.flip();
                result = this.next();
            }
            return result;
        }

        private void print(char next) {
            this.out.print(next);
        }

        private void print(byte next) {
            this.print((char)next);
        }

        public void lineStart() throws Exception {
            this.out.client();
        }

        public void write(String phrase) throws Exception {
            this.out.print(phrase);
            ByteBuffer buffer = StandardCharsets.US_ASCII.encode(phrase);
            this.writeRemaining(buffer);
        }

        public void writeLine(String line) throws Exception {
            this.lineStart();
            this.write(line);
            this.lineEnd();
        }

        private void writeRemaining(ByteBuffer buffer) throws IOException {
            while (buffer.hasRemaining()) {
                this.sump.write(buffer);
            }
        }

        public void lineEnd() throws Exception {
            this.out.lineEnd();
            this.crlf.rewind();
            this.writeRemaining(this.crlf);
        }

        private void readLine() throws Exception {
            this.out.server();
            byte next = this.next();
            this.isLineTagged = next != 42;
            this.readRestOfLine(next);
        }

        private void readRestOfLine(byte next) throws Exception {
            while (next != 13) {
                if (next == 123) {
                    this.startContinuation();
                }
                next = this.next();
            }
            this.next();
        }

        private void startContinuation() throws Exception {
            this.continuationBytes = 0;
            this.continuation();
        }

        private void continuation() throws Exception {
            byte next = this.next();
            switch (next) {
                case 48: {
                    this.continuationDigit(0);
                    break;
                }
                case 49: {
                    this.continuationDigit(1);
                    break;
                }
                case 50: {
                    this.continuationDigit(2);
                    break;
                }
                case 51: {
                    this.continuationDigit(3);
                    break;
                }
                case 52: {
                    this.continuationDigit(4);
                    break;
                }
                case 53: {
                    this.continuationDigit(5);
                    break;
                }
                case 54: {
                    this.continuationDigit(6);
                    break;
                }
                case 55: {
                    this.continuationDigit(7);
                    break;
                }
                case 56: {
                    this.continuationDigit(8);
                    break;
                }
                case 57: {
                    this.continuationDigit(9);
                    break;
                }
                case 43: {
                    this.next();
                    this.next();
                    this.readContinuation();
                    break;
                }
                default: {
                    this.next();
                    this.next();
                    this.readContinuation();
                }
            }
        }

        private void readContinuation() throws Exception {
            this.out.server();
            while (this.continuationBytes-- > 0) {
                byte next = this.next();
                if (next != 10) continue;
                this.out.server();
            }
        }

        private void continuationDigit(int digit) throws Exception {
            this.continuationBytes = 10 * this.continuationBytes + digit;
            this.continuation();
        }

        public void close() throws Exception {
            this.source.close();
            this.sump.close();
        }
    }

    public static final class Fetch {
        static final String[] COMPREHENSIVE_HEADERS = new String[]{"DATE", "FROM", "TO", "CC", "SUBJECT", "REFERENCES", "IN-REPLY-TO", "MESSAGE-ID", "MIME-VERSION", "CONTENT-TYPE", "X-MAILING-LIST", "X-LOOP", "LIST-ID", "LIST-POST", "MAILING-LIST", "ORIGINATOR", "X-LIST", "SENDER", "RETURN-PATH", "X-BEENTHERE"};
        static final String[] SELECT_HEADERS = new String[]{"DATE", "FROM", "TO", "ORIGINATOR", "X-LIST"};
        private boolean flagsFetch = false;
        private boolean rfc822Size = false;
        private boolean rfc = false;
        private boolean rfcText = false;
        private boolean rfcHeaders = false;
        private boolean internalDate = false;
        private boolean uid = false;
        private String body = null;
        private boolean bodyFetch = false;
        private boolean bodyStructureFetch = false;

        public boolean isBodyFetch() {
            return this.bodyFetch;
        }

        public Fetch setBodyFetch(boolean bodyFetch) {
            this.bodyFetch = bodyFetch;
            return this;
        }

        public boolean isBodyStructureFetch() {
            return this.bodyStructureFetch;
        }

        public Fetch setBodyStructureFetch(boolean bodyStructureFetch) {
            this.bodyStructureFetch = bodyStructureFetch;
            return this;
        }

        public String command(int messageNumber) {
            return "FETCH " + messageNumber + "(" + this.fetchData() + ")";
        }

        public String command() {
            return "FETCH 1:* (" + this.fetchData() + ")";
        }

        public boolean isFlagsFetch() {
            return this.flagsFetch;
        }

        public Fetch setFlagsFetch(boolean flagsFetch) {
            this.flagsFetch = flagsFetch;
            return this;
        }

        public boolean isUid() {
            return this.uid;
        }

        public Fetch setUid(boolean uid) {
            this.uid = uid;
            return this;
        }

        public boolean isRfc822Size() {
            return this.rfc822Size;
        }

        public Fetch setRfc822Size(boolean rfc822Size) {
            this.rfc822Size = rfc822Size;
            return this;
        }

        public boolean isRfc() {
            return this.rfc;
        }

        public Fetch setRfc(boolean rfc) {
            this.rfc = rfc;
            return this;
        }

        public boolean isRfcHeaders() {
            return this.rfcHeaders;
        }

        public Fetch setRfcHeaders(boolean rfcHeaders) {
            this.rfcHeaders = rfcHeaders;
            return this;
        }

        public boolean isRfcText() {
            return this.rfcText;
        }

        public Fetch setRfcText(boolean rfcText) {
            this.rfcText = rfcText;
            return this;
        }

        public boolean isInternalDate() {
            return this.internalDate;
        }

        public Fetch setInternalDate(boolean internalDate) {
            this.internalDate = internalDate;
            return this;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String bodyPeek) {
            this.body = bodyPeek;
        }

        public void bodyPeekCompleteMessage() {
            this.setBody(this.buildBody(true, ""));
        }

        public void bodyPeekNotHeaders(String[] fields) {
            this.setBody(this.buildBody(true, this.buildHeaderFields(fields, true)));
        }

        public Fetch bodyPeekHeaders(String[] fields) {
            this.setBody(this.buildBody(true, this.buildHeaderFields(fields, false)));
            return this;
        }

        public String buildBody(boolean peek, String section) {
            StringBuffer result = peek ? new StringBuffer("BODY.PEEK[") : new StringBuffer("BODY[");
            result.append(section).append("]");
            return result.toString();
        }

        public String buildHeaderFields(String[] fields, boolean not) {
            StringBuffer result = not ? new StringBuffer("HEADER.FIELDS.NOT (") : new StringBuffer("HEADER.FIELDS (");
            for (int i = 0; i < fields.length; ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                result.append(fields[i]);
            }
            result.append(")");
            return result.toString();
        }

        public String fetchData() {
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            if (this.flagsFetch) {
                first = this.add(buffer, first, "FLAGS");
            }
            if (this.rfc822Size) {
                first = this.add(buffer, first, "RFC822.SIZE");
            }
            if (this.rfc) {
                first = this.add(buffer, first, "RFC822");
            }
            if (this.rfcHeaders) {
                first = this.add(buffer, first, "RFC822.HEADER");
            }
            if (this.rfcText) {
                first = this.add(buffer, first, "RFC822.TEXT");
            }
            if (this.internalDate) {
                first = this.add(buffer, first, "INTERNALDATE");
            }
            if (this.uid) {
                first = this.add(buffer, first, "UID");
            }
            if (this.bodyFetch) {
                first = this.add(buffer, first, "BODY");
            }
            if (this.bodyStructureFetch) {
                first = this.add(buffer, first, "BODYSTRUCTURE");
            }
            this.add(buffer, first, this.body);
            return buffer.toString();
        }

        private boolean add(StringBuffer buffer, boolean first, String atom) {
            if (atom != null) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(" ");
                }
                buffer.append(atom);
            }
            return first;
        }
    }

    public static final class Search {
        private StringBuffer buffer;
        private boolean first;
        private boolean uidSearch = false;

        public Search() {
            this.clear();
        }

        public boolean isUidSearch() {
            return this.uidSearch;
        }

        public void setUidSearch(boolean uidSearch) {
            this.uidSearch = uidSearch;
        }

        public String command() {
            if (this.uidSearch) {
                return this.buffer.insert(0, "UID SEARCH ").toString();
            }
            return this.buffer.insert(0, "SEARCH ").toString();
        }

        public void clear() {
            this.buffer = new StringBuffer();
            this.first = true;
        }

        private Search append(long term) {
            return this.append(Long.valueOf(term).toString());
        }

        private Search append(String term) {
            if (this.first) {
                this.first = false;
            } else {
                this.buffer.append(' ');
            }
            this.buffer.append(term);
            return this;
        }

        private Search date(int year, int month, int day) {
            this.append(day);
            switch (month) {
                case 1: {
                    this.buffer.append("-Jan-");
                    break;
                }
                case 2: {
                    this.buffer.append("-Feb-");
                    break;
                }
                case 3: {
                    this.buffer.append("-Mar-");
                    break;
                }
                case 4: {
                    this.buffer.append("-Apr-");
                    break;
                }
                case 5: {
                    this.buffer.append("-May-");
                    break;
                }
                case 6: {
                    this.buffer.append("-Jun-");
                    break;
                }
                case 7: {
                    this.buffer.append("-Jul-");
                    break;
                }
                case 8: {
                    this.buffer.append("-Aug-");
                    break;
                }
                case 9: {
                    this.buffer.append("-Sep-");
                    break;
                }
                case 10: {
                    this.buffer.append("-Oct-");
                    break;
                }
                case 11: {
                    this.buffer.append("-Nov-");
                    break;
                }
                case 12: {
                    this.buffer.append("-Dec-");
                }
            }
            this.buffer.append(year);
            return this;
        }

        public Search all() {
            return this.append("ALL");
        }

        public Search answered() {
            return this.append("ANSWERED");
        }

        public Search bcc(String address) {
            return this.append("BCC " + address);
        }

        public Search before(int year, int month, int day) {
            return this.append("BEFORE").date(year, month, day);
        }

        public Search body(String text) {
            return this.append("BODY").append(text);
        }

        public Search cc(String address) {
            return this.append("CC").append(address);
        }

        public Search deleted() {
            return this.append("DELETED");
        }

        public Search draft() {
            return this.append("DRAFT");
        }

        public Search flagged() {
            return this.append("FLAGGED");
        }

        public Search from(String address) {
            return this.append("FROM").append(address);
        }

        public Search header(String field, String value) {
            return this.append("HEADER").append(field).append(value);
        }

        public Search keyword(String flag) {
            return this.append("KEYWORD").append(flag);
        }

        public Search larger(long size) {
            return this.append("LARGER").append(size);
        }

        public Search newOperator() {
            return this.append("NEW");
        }

        public Search not() {
            return this.append("NOT");
        }

        public Search old() {
            return this.append("OLD");
        }

        public Search on(int year, int month, int day) {
            return this.append("ON").date(year, month, day);
        }

        public Search or() {
            return this.append("OR");
        }

        public Search recent() {
            return this.append("RECENT");
        }

        public Search seen() {
            return this.append("SEEN");
        }

        public Search sentbefore(int year, int month, int day) {
            return this.append("SENTBEFORE").date(year, month, day);
        }

        public Search senton(int year, int month, int day) {
            return this.append("SENTON").date(year, month, day);
        }

        public Search sentsince(int year, int month, int day) {
            return this.append("SENTSINCE").date(year, month, day);
        }

        public Search since(int year, int month, int day) {
            return this.append("SINCE").date(year, month, day);
        }

        public Search smaller(int size) {
            return this.append("SMALLER").append(size);
        }

        public Search subject(String address) {
            return this.append("SUBJECT").append(address);
        }

        public Search text(String text) {
            return this.append("TEXT").append(text);
        }

        public Search to(String address) {
            return this.append("TO").append(address);
        }

        public Search uid() {
            return this.append("UID");
        }

        public Search unanswered() {
            return this.append("UNANSWERED");
        }

        public Search undeleted() {
            return this.append("UNDELETED");
        }

        public Search undraft() {
            return this.append("UNDRAFT");
        }

        public Search unflagged() {
            return this.append("UNFLAGGED");
        }

        public Search unkeyword(String flag) {
            return this.append("UNKEYWORD").append(flag);
        }

        public Search unseen() {
            return this.append("UNSEEN");
        }

        public Search openParen() {
            return this.append("(");
        }

        public Search closeParen() {
            return this.append(")");
        }

        public Search msn(int low, int high) {
            return this.append(low + ":" + high);
        }

        public Search msnAndUp(int limit) {
            return this.append(limit + ":*");
        }

        public Search msnAndDown(int limit) {
            return this.append("*:" + limit);
        }
    }

    private static final class IgnoreHeaderInputStream
    extends InputStream {
        private boolean isFinishedHeaders = false;
        private final InputStream delegate;

        public IgnoreHeaderInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            int result;
            int next = this.delegate.read();
            if (this.isFinishedHeaders) {
                result = next;
            } else {
                switch (next) {
                    case -1: {
                        this.isFinishedHeaders = true;
                        result = next;
                        break;
                    }
                    case 35: {
                        this.readLine();
                        result = this.read();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        result = this.read();
                        break;
                    }
                    default: {
                        this.isFinishedHeaders = true;
                        result = next;
                    }
                }
            }
            return result;
        }

        private void readLine() throws IOException {
            int next = this.delegate.read();
            while (next != -1 && next != 13 && next != 10) {
                next = this.delegate.read();
            }
        }
    }

    public static final class Flags {
        private final StringBuffer flags = new StringBuffer("(");
        private final StringBuffer msn = new StringBuffer();
        private boolean first = true;
        private boolean silent = false;
        private boolean add = false;
        private boolean subtract = false;

        public Flags msn(long number) {
            this.msn.append(number);
            this.msn.append(' ');
            return this;
        }

        public Flags range(long low, long high) {
            this.msn.append(low);
            this.msn.append(':');
            this.msn.append(high);
            this.msn.append(' ');
            return this;
        }

        public Flags rangeTill(long number) {
            this.msn.append("*:");
            this.msn.append(number);
            this.msn.append(' ');
            return this;
        }

        public Flags rangeFrom(long number) {
            this.msn.append(number);
            this.msn.append(":* ");
            return this;
        }

        public Flags add() {
            this.add = true;
            this.subtract = false;
            return this;
        }

        public Flags subtract() {
            this.add = false;
            this.subtract = true;
            return this;
        }

        public Flags silent() {
            this.silent = true;
            return this;
        }

        public Flags deleted() {
            return this.append("\\DELETED");
        }

        public Flags flagged() {
            return this.append("\\FLAGGED");
        }

        public Flags answered() {
            return this.append("\\ANSWERED");
        }

        public Flags seen() {
            return this.append("\\SEEN");
        }

        public Flags draft() {
            return this.append("\\DRAFT");
        }

        public String command() {
            Object flags = this.add ? " +FLAGS " : (this.subtract ? " -FLAGS " : " FLAGS ");
            if (this.silent) {
                flags = (String)flags + ".SILENT";
            }
            return "STORE " + this.msn + (String)flags + this.flags + ")";
        }

        private Flags append(String term) {
            if (this.first) {
                this.first = false;
            } else {
                this.flags.append(' ');
            }
            this.flags.append(term);
            return this;
        }
    }

    private static final class Out {
        private static final String OK_APPEND_COMPLETED = "OK APPEND completed.";
        private static final String[] IGNORE_LINES_STARTING_WITH = new String[]{"S: \\* OK \\[PERMANENTFLAGS", "C: A22 LOGOUT", "S: \\* BYE Logging out", "S: \\* OK Dovecot ready\\."};
        private static final String[] IGNORE_LINES_CONTAINING = new String[]{"OK Logout completed.", "LOGIN imapuser password", "OK Logged in", "LOGOUT"};
        private final CharBuffer lineBuffer = CharBuffer.allocate(131072);
        private boolean isClient = false;

        private Out() {
        }

        public void client() {
            this.lineBuffer.put("C: ");
            this.isClient = true;
        }

        public void print(char next) {
            if (!this.isClient) {
                this.escape(next);
            }
            this.lineBuffer.put(next);
        }

        private void escape(char next) {
            if (next == '\\' || next == '*' || next == '.' || next == '[' || next == ']' || next == '+' || next == '(' || next == ')' || next == '{' || next == '}' || next == '?') {
                this.lineBuffer.put('\\');
            }
        }

        public void server() {
            this.lineBuffer.put("S: ");
            this.isClient = false;
        }

        public void print(String phrase) {
            if (!this.isClient) {
                phrase = StringUtils.replace((String)phrase, (String)"\\", (String)"\\\\");
                phrase = StringUtils.replace((String)phrase, (String)"*", (String)"\\*");
                phrase = StringUtils.replace((String)phrase, (String)".", (String)"\\.");
                phrase = StringUtils.replace((String)phrase, (String)"[", (String)"\\[");
                phrase = StringUtils.replace((String)phrase, (String)"]", (String)"\\]");
                phrase = StringUtils.replace((String)phrase, (String)"+", (String)"\\+");
                phrase = StringUtils.replace((String)phrase, (String)"(", (String)"\\(");
                phrase = StringUtils.replace((String)phrase, (String)")", (String)"\\)");
                phrase = StringUtils.replace((String)phrase, (String)"}", (String)"\\}");
                phrase = StringUtils.replace((String)phrase, (String)"{", (String)"\\{");
                phrase = StringUtils.replace((String)phrase, (String)"?", (String)"\\?");
            }
            this.lineBuffer.put(phrase);
        }

        public void lineEnd() {
            String[] lines;
            this.lineBuffer.flip();
            String text = this.lineBuffer.toString();
            for (String line : lines = text.split("\r\n")) {
                Object chompedLine = StringUtils.chomp((String)line);
                if (this.ignoreLine((String)chompedLine)) continue;
                String[] words = StringUtils.split((String)chompedLine);
                if (words.length > 3 && "S:".equalsIgnoreCase(words[0]) && "OK".equalsIgnoreCase(words[2])) {
                    int commandWordIndex;
                    if (words[3] == null || !words[3].startsWith("\\[")) {
                        commandWordIndex = 3;
                    } else {
                        int wordsCount = 3;
                        while (wordsCount < words.length && !words[wordsCount++].endsWith("]")) {
                        }
                        commandWordIndex = wordsCount;
                    }
                    String command = words[commandWordIndex];
                    Object commandOkPhrase = "CREATE".equalsIgnoreCase(command) ? "OK CREATE completed." : ("FETCH".equalsIgnoreCase(command) ? "OK FETCH completed." : ("APPEND".equalsIgnoreCase(command) ? OK_APPEND_COMPLETED : ("DELETE".equalsIgnoreCase(command) ? "OK DELETE completed." : ("STORE".equalsIgnoreCase(command) ? "OK STORE completed." : ("RENAME".equalsIgnoreCase(command) ? "OK RENAME completed." : ("EXPUNGE".equalsIgnoreCase(command) ? "OK EXPUNGE completed." : ("LIST".equalsIgnoreCase(command) ? "OK LIST completed." : ("SELECT".equalsIgnoreCase(command) ? (commandWordIndex == 3 ? "OK SELECT completed." : "OK " + words[3].toUpperCase(Locale.US) + " SELECT completed.") : null))))))));
                    if (commandOkPhrase != null) {
                        chompedLine = words[0] + " " + words[1] + " " + (String)commandOkPhrase;
                    }
                }
                chompedLine = StringUtils.replace((String)chompedLine, (String)"\\\\Seen \\\\Draft", (String)"\\\\Draft \\\\Seen");
                chompedLine = StringUtils.replace((String)chompedLine, (String)"\\\\Flagged \\\\Deleted", (String)"\\\\Deleted \\\\Flagged");
                chompedLine = StringUtils.replace((String)chompedLine, (String)"\\\\Flagged \\\\Draft", (String)"\\\\Draft \\\\Flagged");
                chompedLine = StringUtils.replace((String)chompedLine, (String)"\\\\Seen \\\\Recent", (String)"\\\\Recent \\\\Seen");
                if (((String)(chompedLine = StringUtils.replace((String)chompedLine, (String)"\\] First unseen\\.", (String)"\\](.)*"))).startsWith("S: \\* OK \\[UIDVALIDITY ")) {
                    chompedLine = "S: \\* OK \\[UIDVALIDITY \\d+\\]";
                } else if (((String)chompedLine).startsWith("S: \\* OK \\[UIDNEXT")) {
                    chompedLine = "S: \\* OK \\[PERMANENTFLAGS \\(\\\\Answered \\\\Deleted \\\\Draft \\\\Flagged \\\\Seen\\)\\]";
                }
                System.out.println((String)chompedLine);
            }
            this.lineBuffer.clear();
        }

        private boolean ignoreLine(String line) {
            boolean result = Arrays.stream(IGNORE_LINES_CONTAINING).anyMatch(entry -> line.indexOf((String)entry) > 0);
            for (int i = 0; i < IGNORE_LINES_STARTING_WITH.length && !result; ++i) {
                if (!line.startsWith(IGNORE_LINES_STARTING_WITH[i])) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

