/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.session;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.api.SessionFactory;
import org.apache.james.mpt.session.ExternalSession;
import org.apache.james.util.Port;

public class ExternalSessionFactory
implements SessionFactory {
    public static final String IMAP_SHABANG = "* OK IMAP4rev1 Server ready";
    protected final InetSocketAddress address;
    protected final Monitor monitor;
    protected final String shabang;

    public ExternalSessionFactory(Monitor monitor, String shabang) {
        this(null, monitor, shabang);
    }

    public ExternalSessionFactory(String host, Port port, Monitor monitor, String shabang) {
        this(new InetSocketAddress(host, port.getValue()), monitor, shabang);
    }

    public ExternalSessionFactory(InetSocketAddress address, Monitor monitor, String shabang) {
        this.monitor = monitor;
        this.shabang = shabang;
        this.address = address;
    }

    @Override
    public Session newSession(Continuation continuation) throws Exception {
        InetSocketAddress address = this.getAddress();
        this.monitor.note("Connecting to " + address.getHostName() + ":" + address.getPort());
        SocketChannel channel = SocketChannel.open(address);
        channel.configureBlocking(false);
        return new ExternalSession(channel, this.monitor, this.shabang);
    }

    protected InetSocketAddress getAddress() {
        return this.address;
    }

    public String toString() {
        String TAB = " ";
        return "ExternalSessionFactory ( address = " + this.getAddress() + " monitor = " + this.monitor + " shabang = " + this.shabang + "  )";
    }
}

