/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.session;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.Session;
import org.awaitility.Awaitility;
import org.awaitility.Durations;

public final class ExternalSession
implements Session {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final SocketChannel socket;
    private final Monitor monitor;
    private final ByteBuffer readBuffer;
    private final ByteBuffer lineEndBuffer;
    private boolean first = true;
    private final String shabang;

    public ExternalSession(SocketChannel socket, Monitor monitor, String shabang) {
        this(socket, monitor, shabang, false);
    }

    public ExternalSession(SocketChannel socket, Monitor monitor, String shabang, boolean debug) {
        this.socket = socket;
        this.monitor = monitor;
        this.readBuffer = ByteBuffer.allocateDirect(2048);
        this.lineEndBuffer = ByteBuffer.wrap(CRLF);
        this.shabang = shabang;
    }

    @Override
    public String readLine() throws Exception {
        String result;
        StringBuffer buffer = new StringBuffer();
        this.readlineInto(buffer);
        if (this.first && this.shabang != null) {
            this.monitor.note("<-" + buffer.toString());
            result = this.shabang;
            this.first = false;
        } else {
            result = buffer.toString();
            this.monitor.note("<-" + result);
        }
        return result;
    }

    private void readlineInto(StringBuffer buffer) throws Exception {
        this.monitor.debug("[Reading line]");
        this.readBuffer.flip();
        while (this.oneFromLine(buffer)) {
        }
        this.readBuffer.compact();
        this.monitor.debug("[Done]");
    }

    private boolean oneFromLine(StringBuffer buffer) throws Exception {
        boolean result;
        if (this.readBuffer.hasRemaining()) {
            char next = (char)this.readBuffer.get();
            if (next == '\n') {
                this.monitor.debug("[LF]");
                result = false;
            } else if (next == '\r') {
                this.monitor.debug("[CR]");
                result = true;
            } else {
                this.monitor.debug(next);
                buffer.append(next);
                result = true;
            }
        } else {
            this.monitor.debug("[Reading into buffer]");
            this.readBuffer.clear();
            result = this.tryReadFromSocket();
            this.readBuffer.flip();
            this.monitor.debug(String.format("[Read %d characters]", this.readBuffer.limit()));
        }
        return result;
    }

    private boolean tryReadFromSocket() throws IOException, InterruptedException {
        MutableInt status = new MutableInt(0);
        Awaitility.waitAtMost((Duration)Durations.ONE_MINUTE).pollDelay(Duration.ofMillis(10L)).until(() -> {
            int read = this.socket.read(this.readBuffer);
            status.setValue(read);
            return read != 0;
        });
        if (status.intValue() == -1) {
            this.monitor.debug("Error reading, got -1");
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        while (!this.socket.finishConnect()) {
            this.monitor.note("connecting...");
            Thread.sleep(10L);
        }
    }

    @Override
    public void restart() throws Exception {
        throw new NotImplementedException("Restart is not implemented for ExternalSession");
    }

    @Override
    public void stop() throws Exception {
        this.monitor.note("closing");
        this.socket.close();
    }

    @Override
    public void writeLine(String line) throws Exception {
        this.monitor.note("-> " + line);
        this.monitor.debug("[Writing line]");
        this.socket.write(ByteBuffer.wrap((line + "\r\n").getBytes(StandardCharsets.US_ASCII)));
        this.monitor.debug("[Done]");
    }

    @Override
    public void await() throws Exception {
        TimeUnit.SECONDS.sleep(5L);
    }

    public String toString() {
        String TAB = " ";
        return "External ( socket = " + this.socket + " monitor = " + this.monitor + " readBuffer = " + this.readBuffer + " lineEndBuffer = " + this.lineEndBuffer + " first = " + this.first + " shabang = " + this.shabang + "  )";
    }
}

