/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.app;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.james.mpt.app.RunScript;
import org.apache.james.util.Port;

public class Main {
    private static final int FILE_NOT_FOUND = 1;
    private static final int PORT_NOT_A_NUMBER = 2;
    private static final String FILE_OPTION = "f";
    private static final String PORT_OPTION = "p";
    private static final String HOST_OPTION = "h";
    private static final String SHABANG_OPTION = "s";
    private static final String VERBOSE_OPTION = "v";

    public static void main(String[] args) throws Exception {
        Options options = Main.buildOptions();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            Main.runCommand(cmd);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            new HelpFormatter().printHelp("mpt", options);
            System.exit(-1);
        }
    }

    private static void runCommand(CommandLine cmd) throws Exception {
        boolean verbose = Boolean.parseBoolean(cmd.getOptionValue(VERBOSE_OPTION, Boolean.toString(false)));
        File file = new File(cmd.getOptionValue(FILE_OPTION));
        if (file.exists()) {
            try {
                Port port = new Port(Integer.parseInt(cmd.getOptionValue(PORT_OPTION)));
                String host = cmd.getOptionValue(HOST_OPTION, "localhost");
                String shabang = cmd.getOptionValue(SHABANG_OPTION, null);
                RunScript runner = new RunScript(file, port, host, shabang, verbose);
                runner.run();
            }
            catch (NumberFormatException e) {
                System.out.println("Port must be numeric");
                System.exit(2);
            }
        } else {
            System.out.println("Script not found");
            System.exit(1);
        }
    }

    private static Options buildOptions() {
        Options options = new Options();
        Main.addRunScriptOptions(options);
        return options;
    }

    private static void addRunScriptOptions(Options options) {
        options.addOption(Option.builder(FILE_OPTION).argName("file").hasArg().desc("run this script").longOpt("file").required().build());
        options.addOption(Option.builder(PORT_OPTION).argName("port").hasArg().desc("runs against this port").longOpt("port").required().build());
        options.addOption(Option.builder(HOST_OPTION).argName("host").hasArg().desc("runs against this host (defaults to localhost)").longOpt("host").required(false).build());
        options.addOption(Option.builder(SHABANG_OPTION).argName("shabang").hasArg().desc("sets shabang (defaults to empty)").longOpt("shabang").required(false).build());
        options.addOption(Option.builder(VERBOSE_OPTION).desc("prints lots of logging").longOpt("verbose").required(false).build());
    }
}

