/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.scanning;

import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.quota.search.QuotaSearchTestSystem;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.scanning.ClauseConverter;
import org.apache.james.quota.search.scanning.ScanningQuotaSearcher;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.mockito.Mockito;

public class MemoryQuotaSearchTestSystemExtension
implements ParameterResolver {
    private static final Runnable NO_AWAIT = () -> {};

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == QuotaSearchTestSystem.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            InMemoryIntegrationResources resources = InMemoryIntegrationResources.defaultResources();
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            MemoryDomainList domainList = new MemoryDomainList(dnsService);
            domainList.configure(DomainListConfiguration.DEFAULT);
            MemoryUsersRepository usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
            QuotaComponents quotaComponents = resources.getMailboxManager().getQuotaComponents();
            return new QuotaSearchTestSystem(quotaComponents.getMaxQuotaManager(), (MailboxManager)resources.getMailboxManager(), quotaComponents.getQuotaManager(), (UserQuotaRootResolver)resources.getDefaultUserQuotaRootResolver(), (QuotaSearcher)new ScanningQuotaSearcher((UsersRepository)usersRepository, new ClauseConverter((UserQuotaRootResolver)resources.getDefaultUserQuotaRootResolver(), quotaComponents.getQuotaManager())), (UsersRepository)usersRepository, (DomainList)domainList, resources.getCurrentQuotaManager(), NO_AWAIT);
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Error while resolving parameter", (Throwable)e);
        }
    }
}

