/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch.json;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRatio;
import org.apache.james.quota.search.opensearch.json.QuotaRatioAsJson;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QuotaRatioAsJsonTest {
    static final Quota<QuotaSizeLimit, QuotaSizeUsage> QUOTA_SIZE = Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)15L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size((long)60L)).build();
    static final Quota<QuotaCountLimit, QuotaCountUsage> QUOTA_COUNT = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)1L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)2L)).build();

    QuotaRatioAsJsonTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaRatioAsJson.class).verify();
    }

    @Test
    void buildShouldThrownWhenUserIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaRatioAsJson.builder().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrownWhenUserIsEmpty() {
        Assertions.assertThatThrownBy(() -> QuotaRatioAsJson.builder().user("").build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrownWhenQuotaRatioIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaRatioAsJson.builder().user("user").build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void getDomainShouldReturnEmptyWhenNone() {
        QuotaRatioAsJson quotaRatioAsJson = QuotaRatioAsJson.builder().user("user").quotaRatio(QuotaRatio.from(QUOTA_SIZE, QUOTA_COUNT)).sizeUsed(1L).countUsed(2L).build();
        Assertions.assertThat((Optional)quotaRatioAsJson.getDomain()).isEmpty();
    }

    @Test
    void getDomainShouldReturnTheDomainWhenGiven() {
        String domain = "domain";
        QuotaRatioAsJson quotaRatioAsJson = QuotaRatioAsJson.builder().user("user").domain(Optional.of(domain)).quotaRatio(QuotaRatio.from(QUOTA_SIZE, QUOTA_COUNT)).sizeUsed(1L).countUsed(2L).build();
        Assertions.assertThat((Optional)quotaRatioAsJson.getDomain()).contains((Object)domain);
    }

    @Test
    void getMaxQuotaRatioShouldReturnTheMaxQuotaRatio() {
        String domain = "domain";
        QuotaRatioAsJson quotaRatioAsJson = QuotaRatioAsJson.builder().user("user").domain(Optional.of(domain)).quotaRatio(QuotaRatio.from(QUOTA_SIZE, QUOTA_COUNT)).sizeUsed(1L).countUsed(2L).build();
        Assertions.assertThat((double)quotaRatioAsJson.getMaxQuotaRatio()).isEqualTo(0.5);
    }
}

