/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch.events;

import java.io.IOException;
import org.apache.james.backends.opensearch.DockerOpenSearchExtension;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.events.Event;
import org.apache.james.events.Group;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.quota.QuotaFixture;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.quota.search.QuotaSearchFixture;
import org.apache.james.quota.search.opensearch.QuotaRatioOpenSearchConstants;
import org.apache.james.quota.search.opensearch.QuotaSearchIndexCreationUtil;
import org.apache.james.quota.search.opensearch.UserRoutingKeyFactory;
import org.apache.james.quota.search.opensearch.events.OpenSearchQuotaMailboxListener;
import org.apache.james.quota.search.opensearch.json.QuotaRatioToOpenSearchJson;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;

class OpenSearchQuotaMailboxListenerTest {
    private static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await();
    static Event.EventId EVENT_ID = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b4");
    @RegisterExtension
    static DockerOpenSearchExtension openSearch = new DockerOpenSearchExtension((DockerOpenSearchExtension.CleanupStrategy)new DockerOpenSearchExtension.DeleteAllIndexDocumentsCleanupStrategy(new WriteAliasName("quota_ratio_write_alias")));
    static ReactorOpenSearchClient client;
    OpenSearchQuotaMailboxListener quotaMailboxListener;

    OpenSearchQuotaMailboxListenerTest() {
    }

    @BeforeAll
    static void beforeAll() throws IOException {
        client = openSearch.getDockerOpenSearch().clientProvider().get();
        QuotaSearchIndexCreationUtil.prepareDefaultClient((ReactorOpenSearchClient)client, (OpenSearchConfiguration)OpenSearchConfiguration.builder().addHost(openSearch.getDockerOpenSearch().getHttpHost()).build());
    }

    @AfterAll
    static void afterAll() throws IOException {
        client.close();
    }

    @BeforeEach
    void setUp() {
        DefaultUserQuotaRootResolver quotaRootResolver = new DefaultUserQuotaRootResolver((SessionProvider)Mockito.mock(SessionProvider.class), (MailboxSessionMapperFactory)Mockito.mock(MailboxSessionMapperFactory.class));
        this.quotaMailboxListener = new OpenSearchQuotaMailboxListener(new OpenSearchIndexer(client, QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_WRITE_ALIAS), new QuotaRatioToOpenSearchJson((QuotaRootResolver)quotaRootResolver), (RoutingKey.Factory)new UserRoutingKeyFactory(), (QuotaRootResolver)quotaRootResolver);
    }

    @Test
    void deserializeOpenSearchQuotaMailboxListenerGroup() throws Exception {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.quota.search.opensearch.events.OpenSearchQuotaMailboxListener$OpenSearchQuotaMailboxListenerGroup")).isEqualTo((Object)new OpenSearchQuotaMailboxListener.OpenSearchQuotaMailboxListenerGroup());
    }

    @Test
    void eventShouldIndexEventWhenQuotaEvent() throws Exception {
        this.quotaMailboxListener.event((Event)((EventFactory.QuotaUsageUpdatedFinalStage)((EventFactory.RequireInstant)((EventFactory.RequireQuotaSize)((EventFactory.RequireQuotaCount)((EventFactory.RequireQuotaRoot)((EventFactory.RequireUser)EventFactory.quotaUpdated().eventId(EVENT_ID)).user(QuotaSearchFixture.TestConstants.BOB_USERNAME)).quotaRoot(QuotaSearchFixture.TestConstants.QUOTAROOT)).quotaCount(QuotaFixture.Counts._52_PERCENT)).quotaSize(QuotaFixture.Sizes._55_PERCENT)).instant(QuotaSearchFixture.TestConstants.NOW)).build());
        CALMLY_AWAIT.atMost(Durations.ONE_MINUTE).untilAsserted(() -> Assertions.assertThat((long)((SearchResponse)client.search(new SearchRequest.Builder().index(QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_READ_ALIAS.getValue(), new String[0]).query(new MatchAllQuery.Builder().build().toQuery()).build()).block()).hits().total().value()).isEqualTo(1L));
    }
}

