/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import org.apache.james.core.Domain;
import org.apache.james.quota.search.QuotaBoundary;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.opensearch.QuotaQueryConverter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;

class QuotaQueryConverterTest {
    QuotaQueryConverter testee;

    QuotaQueryConverterTest() {
    }

    @BeforeEach
    void setup() {
        this.testee = new QuotaQueryConverter();
    }

    @Test
    void fromShouldReturnMatchAllWhenEmptyClauses() {
        QuotaQuery query = QuotaQuery.builder().build();
        Query expected = new MatchAllQuery.Builder().build().toQuery();
        Query actual = this.testee.from(query);
        SoftAssertions.assertSoftly(softly -> Assertions.assertThat((Comparable)actual._kind()).isEqualTo((Object)expected._kind()));
    }

    @Test
    void fromShouldReturnDomainMatchWhenOnlyDomain() {
        QuotaQuery query = QuotaQuery.builder().hasDomain(Domain.of((String)"my.tld")).build();
        Query expected = new TermQuery.Builder().field("domain").value((FieldValue)new FieldValue.Builder().stringValue("my.tld").build()).build().toQuery();
        Query actual = this.testee.from(query);
        SoftAssertions.assertSoftly(softly -> {
            Assertions.assertThat((Comparable)actual._kind()).isEqualTo((Object)expected._kind());
            Assertions.assertThat((String)actual.term().field()).isEqualTo(expected.term().field());
            Assertions.assertThat((String)actual.term().value().stringValue()).isEqualTo(expected.term().value().stringValue());
        });
    }

    @Test
    void fromShouldReturnQuotaRatioMatchWhenLessThan() {
        QuotaQuery query = QuotaQuery.builder().lessThan(new QuotaBoundary(0.1)).build();
        Query expected = new RangeQuery.Builder().field("quotaRatio").lte(JsonData.of((Object)0.1)).build().toQuery();
        Query actual = this.testee.from(query);
        SoftAssertions.assertSoftly(softly -> {
            Assertions.assertThat((Comparable)actual._kind()).isEqualTo((Object)expected._kind());
            Assertions.assertThat((String)actual.range().field()).isEqualTo(expected.range().field());
            Assertions.assertThat((Double)((Double)actual.range().lte().to(Double.class))).isEqualTo((Double)expected.range().lte().to(Double.class));
        });
    }

    @Test
    void fromShouldReturnQuotaRatioMatchWhenMoreThan() {
        QuotaQuery query = QuotaQuery.builder().moreThan(new QuotaBoundary(0.1)).build();
        Query expected = new RangeQuery.Builder().field("quotaRatio").gte(JsonData.of((Object)0.1)).build().toQuery();
        Query actual = this.testee.from(query);
        SoftAssertions.assertSoftly(softly -> {
            Assertions.assertThat((Comparable)actual._kind()).isEqualTo((Object)expected._kind());
            Assertions.assertThat((String)actual.range().field()).isEqualTo(expected.range().field());
            Assertions.assertThat((Double)((Double)actual.range().gte().to(Double.class))).isEqualTo((Double)expected.range().gte().to(Double.class));
        });
    }
}

