/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.james.core.CoreFixture;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.Offset;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearchTestSystem;
import org.apache.james.quota.search.QuotaSearcherContract;
import org.apache.james.quota.search.opensearch.OpenSearchQuotaSearchTestSystemExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={OpenSearchQuotaSearchTestSystemExtension.class})
class OpenSearchQuotaSearcherTest
implements QuotaSearcherContract {
    OpenSearchQuotaSearcherTest() {
    }

    @Test
    void searchShouldNotBeLimitedByOpenSearchDefaultSearchLimit(QuotaSearchTestSystem testSystem) throws Exception {
        int userCount = 11;
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        IntStream.range(0, userCount).boxed().map(i -> Username.fromLocalPartWithDomain((String)("user" + i), (Domain)CoreFixture.Domains.SIMPSON_COM)).forEach(user -> this.provisionUser(testSystem, (Username)user));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().withLimit(Limit.unlimited()).build())).hasSize(userCount));
    }

    @Test
    void searchShouldNotBeLimitedByOpenSearchDefaultSearchLimitWhenUsingOffset(QuotaSearchTestSystem testSystem) throws Exception {
        int userCount = 12;
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        IntStream.range(0, userCount).boxed().map(i -> Username.fromLocalPartWithDomain((String)("user" + i), (Domain)CoreFixture.Domains.SIMPSON_COM)).forEach(user -> this.provisionUser(testSystem, (Username)user));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().withLimit(Limit.unlimited()).withOffset(Offset.of((int)1)).build())).hasSize(userCount - 1));
    }

    private void provisionUser(QuotaSearchTestSystem testSystem, Username username) {
        try {
            testSystem.getUsersRepository().addUser(username, "any");
            this.appendMessage(testSystem, username, this.withSize(49));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

