/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import java.io.IOException;
import org.apache.james.backends.opensearch.DockerOpenSearch;
import org.apache.james.backends.opensearch.DockerOpenSearchSingleton;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.events.EventListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.quota.search.QuotaSearchTestSystem;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.opensearch.OpenSearchQuotaSearcher;
import org.apache.james.quota.search.opensearch.QuotaRatioOpenSearchConstants;
import org.apache.james.quota.search.opensearch.QuotaSearchIndexCreationUtil;
import org.apache.james.quota.search.opensearch.UserRoutingKeyFactory;
import org.apache.james.quota.search.opensearch.events.OpenSearchQuotaMailboxListener;
import org.apache.james.quota.search.opensearch.json.QuotaRatioToOpenSearchJson;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.mockito.Mockito;

public class OpenSearchQuotaSearchTestSystemExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private final DockerOpenSearch openSearch = DockerOpenSearchSingleton.INSTANCE;
    private ReactorOpenSearchClient client;

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == QuotaSearchTestSystem.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            this.client = QuotaSearchIndexCreationUtil.prepareDefaultClient((ReactorOpenSearchClient)this.openSearch.clientProvider().get(), (OpenSearchConfiguration)this.openSearch.configuration());
            InMemoryIntegrationResources resources = InMemoryIntegrationResources.defaultResources();
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            MemoryDomainList domainList = new MemoryDomainList(dnsService);
            domainList.configure(DomainListConfiguration.DEFAULT);
            MemoryUsersRepository usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
            OpenSearchQuotaMailboxListener listener = new OpenSearchQuotaMailboxListener(new OpenSearchIndexer(this.client, QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_WRITE_ALIAS), new QuotaRatioToOpenSearchJson(resources.getQuotaRootResolver()), (RoutingKey.Factory)new UserRoutingKeyFactory(), resources.getQuotaRootResolver());
            resources.getMailboxManager().getEventBus().register((EventListener.ReactiveGroupEventListener)listener);
            QuotaComponents quotaComponents = resources.getMailboxManager().getQuotaComponents();
            return new QuotaSearchTestSystem(quotaComponents.getMaxQuotaManager(), (MailboxManager)resources.getMailboxManager(), quotaComponents.getQuotaManager(), (UserQuotaRootResolver)resources.getDefaultUserQuotaRootResolver(), (QuotaSearcher)new OpenSearchQuotaSearcher(this.client, QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_READ_ALIAS), (UsersRepository)usersRepository, (DomainList)domainList, resources.getCurrentQuotaManager(), () -> ((DockerOpenSearch)this.openSearch).flushIndices());
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Error while resolving parameter", (Throwable)e);
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.openSearch.start();
    }

    public void afterEach(ExtensionContext context) throws IOException {
        this.client.close();
        this.openSearch.cleanUpData();
    }
}

