/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.quota.search.opensearch.OpenSearchQuotaConfiguration;
import org.apache.james.quota.search.opensearch.QuotaRatioOpenSearchConstants;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OpenSearchQuotaConfigurationTest {
    OpenSearchQuotaConfigurationTest() {
    }

    @Test
    void getReadAliasQuotaRatioNameShouldReturnConfiguredValue() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String name = "name";
        configuration.addProperty("opensearch.alias.read.quota.ratio.name", (Object)name);
        configuration.addProperty("opensearch.hosts", (Object)"127.0.0.1");
        OpenSearchQuotaConfiguration openSearchQuotaConfiguration = OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        Assertions.assertThat((Object)openSearchQuotaConfiguration.getReadAliasQuotaRatioName()).isEqualTo((Object)new ReadAliasName(name));
    }

    @Test
    void getReadAliasQuotaRatioNameShouldReturnDefaultValueWhenMissing() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("opensearch.hosts", (Object)"127.0.0.1");
        OpenSearchQuotaConfiguration openSearchConfiguration = OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        Assertions.assertThat((Object)openSearchConfiguration.getReadAliasQuotaRatioName()).isEqualTo((Object)QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_READ_ALIAS);
    }

    @Test
    void getWriteAliasQuotaRatioNameShouldReturnConfiguredValue() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String name = "name";
        configuration.addProperty("opensearch.alias.write.quota.ratio.name", (Object)name);
        configuration.addProperty("opensearch.hosts", (Object)"127.0.0.1");
        OpenSearchQuotaConfiguration openSearchConfiguration = OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        Assertions.assertThat((Object)openSearchConfiguration.getWriteAliasQuotaRatioName()).isEqualTo((Object)new WriteAliasName(name));
    }

    @Test
    void getWriteAliasQuotaRatioNameShouldReturnDefaultValueWhenMissing() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("opensearch.hosts", (Object)"127.0.0.1");
        OpenSearchQuotaConfiguration openSearchConfiguration = OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        Assertions.assertThat((Object)openSearchConfiguration.getWriteAliasQuotaRatioName()).isEqualTo((Object)QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_WRITE_ALIAS);
    }

    @Test
    void getIndexQuotaRatioNameShouldReturnConfiguredValue() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String name = "name";
        configuration.addProperty("opensearch.index.quota.ratio.name", (Object)name);
        configuration.addProperty("opensearch.hosts", (Object)"127.0.0.1");
        OpenSearchQuotaConfiguration openSearchConfiguration = OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        Assertions.assertThat((Object)openSearchConfiguration.getIndexQuotaRatioName()).isEqualTo((Object)new IndexName(name));
    }

    @Test
    void getIndexQuotaRatioNameShouldReturnDefaultValueWhenMissing() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("opensearch.hosts", (Object)"127.0.0.1");
        OpenSearchQuotaConfiguration openSearchConfiguration = OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        Assertions.assertThat((Object)openSearchConfiguration.getIndexQuotaRatioName()).isEqualTo((Object)QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_INDEX);
    }
}

