/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneTestsUtils {
    static final Function<Document, String> documentStringFormatter = field -> "\n\t * " + String.valueOf(field);
    private static final Logger log = LoggerFactory.getLogger(LuceneTestsUtils.class);

    LuceneTestsUtils() {
    }

    static List<Document> getAllDocumentsFromRepository(IndexReader reader) {
        ArrayList<Document> result = new ArrayList<Document>(reader.maxDoc());
        for (int i = 0; i < reader.maxDoc(); ++i) {
            try {
                result.add(reader.storedFields().document(i));
                continue;
            }
            catch (IOException e) {
                log.error("Problem getting document for index: {}", (Object)i);
            }
        }
        return result;
    }
}

