/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.Flags;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.lucene.search.LuceneTestsUtils;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneMailboxMessageFlagSearchTest {
    protected static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await();
    protected static final long LIMIT = 100L;
    protected static final boolean RECENT = true;
    protected static final boolean NOT_RECENT = false;
    protected static final String INBOX = "INBOX";
    private static final Logger log = LoggerFactory.getLogger(LuceneMailboxMessageFlagSearchTest.class);
    private static final Username USERNAME = Username.of((String)"username");
    protected MessageSearchIndex messageSearchIndex;
    protected StoreMailboxManager storeMailboxManager;
    protected MessageIdManager messageIdManager;
    protected EventBus eventBus;
    protected MessageId.Factory messageIdFactory;
    protected UpdatableTickingClock clock;
    private StoreMessageManager inboxMessageManager;
    private MailboxSession session;
    private LuceneMessageSearchIndex luceneMessageSearchIndex;
    private Mailbox mailbox;
    private ComposedMessageId m1;
    private ComposedMessageId m2;
    private ComposedMessageId m3;
    private ComposedMessageId m4;

    LuceneMailboxMessageFlagSearchTest() {
    }

    private static BooleanQuery.Builder getQueryBuilderFlagId(long mailboxId, long messageId) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        String flagsId = "flags-" + mailboxId + "-" + messageId;
        queryBuilder.add((Query)new TermQuery(new Term("id", flagsId)), BooleanClause.Occur.MUST);
        return queryBuilder;
    }

    protected boolean useLenient() {
        return true;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.initializeMailboxManager();
        this.clock = (UpdatableTickingClock)this.storeMailboxManager.getClock();
        this.luceneMessageSearchIndex = (LuceneMessageSearchIndex)this.messageSearchIndex;
        this.session = this.storeMailboxManager.createSystemSession(USERNAME);
        MailboxPath inboxPath = MailboxPath.inbox((Username)USERNAME);
        this.storeMailboxManager.createMailbox(inboxPath, this.session);
        this.inboxMessageManager = (StoreMessageManager)this.storeMailboxManager.getMailbox(inboxPath, this.session);
        this.mailbox = this.inboxMessageManager.getMailboxEntity();
    }

    private void addM4() throws MailboxException {
        this.m4 = this.addEmail(this.m4, "eml/mail4.eml", 1396389600000L);
    }

    private void addM3() throws MailboxException {
        this.m3 = this.addEmail(this.m3, "eml/mail3.eml", 1398981600000L);
    }

    private void addM2() throws MailboxException {
        this.m2 = this.addEmail(this.m2, "eml/mail2.eml", 1393714800000L);
    }

    private void addM1() throws MailboxException {
        this.m1 = this.addEmail(this.m1, "eml/mail1.eml", 1391295600000L);
    }

    private ComposedMessageId addEmail(ComposedMessageId messageId, String name, long date) throws MailboxException {
        return this.inboxMessageManager.appendMessage(ClassLoader.getSystemResourceAsStream(name), new Date(date), this.session, false, new Flags()).getId();
    }

    private void initializeMailboxManager() {
        InMemoryIntegrationResources resources = InMemoryIntegrationResources.builder().preProvisionnedFakeAuthenticator().fakeAuthorizator().inVmEventBus().defaultAnnotationLimits().defaultMessageParser().listeningSearchIndex((Function)Throwing.function(preInstanciationStage -> new LuceneMessageSearchIndex((MailboxSessionMapperFactory)preInstanciationStage.getMapperFactory(), (MailboxId.Factory)new InMemoryId.Factory(), (Directory)new ByteBuffersDirectory(), (MessageId.Factory)new InMemoryMessageId.Factory(), preInstanciationStage.getSessionProvider()))).noPreDeletionHooks().storeQuotaManager().build();
        this.storeMailboxManager = resources.getMailboxManager();
        this.messageIdManager = resources.getMessageIdManager();
        this.messageSearchIndex = resources.getSearchIndex();
        this.eventBus = resources.getEventBus();
        this.messageIdFactory = new InMemoryMessageId.Factory();
    }

    @Test
    void updateSingleDocument() throws MailboxException, IOException {
        ScoreDoc[] scoreDocs;
        BooleanQuery.Builder queryBuilder;
        IndexSearcher searcher;
        List<Document> allDocumentsFromRepository;
        this.m1 = this.addEmail(this.m1, "eml/mail1.eml", 1391295600000L);
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.luceneMessageSearchIndex.writer);){
            allDocumentsFromRepository = LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader);
            log.trace("Lucene repository initial: {}", allDocumentsFromRepository.stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            searcher = new IndexSearcher((IndexReader)reader);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 1L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
        }
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, MessageRange.one((MessageUid)this.m1.getUid()), this.session);
        reader = DirectoryReader.open((IndexWriter)this.luceneMessageSearchIndex.writer);
        try {
            allDocumentsFromRepository = LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader);
            log.trace("Lucene repository state after adding SEEN flag, size: {}, docs: {}", (Object)allDocumentsFromRepository.size(), allDocumentsFromRepository.stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            searcher = new IndexSearcher((IndexReader)reader);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 1L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.ANSWERED), MessageManager.FlagsUpdateMode.ADD, MessageRange.one((MessageUid)this.m1.getUid()), this.session);
        reader = DirectoryReader.open((IndexWriter)this.luceneMessageSearchIndex.writer);
        try {
            allDocumentsFromRepository = LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader);
            log.trace("Lucene repository state after adding ANSWERED flag, size: {}, docs: {}", (Object)allDocumentsFromRepository.size(), allDocumentsFromRepository.stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            searcher = new IndexSearcher((IndexReader)reader);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 1L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.REPLACE, MessageRange.one((MessageUid)this.m1.getUid()), this.session);
        reader = DirectoryReader.open((IndexWriter)this.luceneMessageSearchIndex.writer);
        try {
            allDocumentsFromRepository = LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader);
            log.trace("Lucene repository state after setting SEEN as only flag, size: {}, docs: {}", (Object)allDocumentsFromRepository.size(), allDocumentsFromRepository.stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            searcher = new IndexSearcher((IndexReader)reader);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 1L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.REMOVE, MessageRange.one((MessageUid)this.m1.getUid()), this.session);
        reader = DirectoryReader.open((IndexWriter)this.luceneMessageSearchIndex.writer);
        try {
            allDocumentsFromRepository = LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader);
            log.trace("Lucene repository state after removing SEEN flag (no flag left), size: {}, docs: {}", (Object)allDocumentsFromRepository.size(), allDocumentsFromRepository.stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            searcher = new IndexSearcher((IndexReader)reader);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 1L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    void searchShouldReturnCorrectNumberOfMessagesWhenFlagsGotUpdated() throws MailboxException, IOException {
        this.m1 = this.addEmail(this.m1, "eml/mail1.eml", 1391295600000L);
        this.m2 = this.addEmail(this.m2, "eml/mail2.eml", 1393714800000L);
        this.m3 = this.addEmail(this.m3, "eml/mail3.eml", 1398981600000L);
        this.m4 = this.addEmail(this.m4, "eml/mail4.eml", 1396389600000L);
        log.trace("[1] Fresh state, all documents without flags (expected seen: 0, not-seen: 4, empty query: 4");
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isZero();
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).isEmpty();
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        log.trace("[2] Setting SEEN for all messages (expected seen: 4, not-seen: 0, empty query: 4");
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, MessageRange.range((MessageUid)this.m1.getUid(), (MessageUid)this.m4.getUid()), this.session);
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isZero();
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).isEmpty();
        log.trace("[3] Removing SEEN from m3 & m4 (expected seen: 2, not-seen: 2, empty query: 4");
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.REMOVE, MessageRange.range((MessageUid)this.m3.getUid(), (MessageUid)this.m4.getUid()), this.session);
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isEqualTo(2L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).containsExactly((Object[])new MessageUid[]{this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isEqualTo(2L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid()});
        log.trace("[4] re-adding SEEN to m3 & m4 (expected seen: 4, not-seen: 0, empty query: 4");
        this.inboxMessageManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, MessageRange.range((MessageUid)this.m3.getUid(), (MessageUid)this.m4.getUid()), this.session);
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[0])).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isEqualTo(4L);
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).containsExactly((Object[])new MessageUid[]{this.m1.getUid(), this.m2.getUid(), this.m3.getUid(), this.m4.getUid()});
        Assertions.assertThat((long)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream().count()).isZero();
        Assertions.assertThat((Stream)this.messageSearchIndex.search(this.session, this.mailbox, SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)})).toStream()).isEmpty();
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.luceneMessageSearchIndex.writer);){
            List<Document> allDocumentsFromRepository = LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader);
            log.trace("Lucene repository final state after updating all messages, size: {}, docs {}", (Object)allDocumentsFromRepository.size(), allDocumentsFromRepository.stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            BooleanQuery.Builder queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 1L);
            ScoreDoc[] scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 2L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 3L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
            queryBuilder = LuceneMailboxMessageFlagSearchTest.getQueryBuilderFlagId(1L, 4L);
            scoreDocs = searcher.search((Query)queryBuilder.build(), (int)50).scoreDocs;
            Assertions.assertThat((int)scoreDocs.length).isEqualTo(1);
        }
    }
}

