/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import java.io.IOException;
import org.apache.james.mailbox.lucene.search.LuceneTestsUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneGenericTests {
    private static final String ID_FIELD = "id";
    private static final String FLAGS_FIELD = "flags";
    private static final Logger log = LoggerFactory.getLogger(LuceneGenericTests.class);
    private static IndexWriter writer;

    @BeforeEach
    void setUp() throws IOException {
        ByteBuffersDirectory memoryIndex = new ByteBuffersDirectory();
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)analyzer);
        writer = new IndexWriter((Directory)memoryIndex, indexWriterConfig);
    }

    @Test
    void testAddingAndUpdatingDocument() throws IOException {
        Document foundDoc;
        TopDocs foundDocuments;
        TermQuery termQuery;
        Term term;
        IndexSearcher indexSearcher;
        String flagsOneOne = "flags-1-1";
        String seenFlag = "flags:/SEEN";
        String answeredFlag = "flags:/ANSWERED";
        Document document = new Document();
        document.add((IndexableField)new StringField(ID_FIELD, flagsOneOne, Field.Store.YES));
        document.add((IndexableField)new StringField(FLAGS_FIELD, "", Field.Store.YES));
        log.trace("Writing initial document for flags-1-1: {}", (Object)document);
        writer.addDocument((Iterable)document);
        Document document2 = new Document();
        document2.add((IndexableField)new StringField(ID_FIELD, "flags-1-2", Field.Store.YES));
        document2.add((IndexableField)new StringField(FLAGS_FIELD, "flags:/SEEN", Field.Store.YES));
        log.trace("Writing initial document for flags-1-2: {}", (Object)document);
        writer.addDocument((Iterable)document2);
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)writer);){
            indexSearcher = new IndexSearcher((IndexReader)reader);
            term = new Term(ID_FIELD, flagsOneOne);
            termQuery = new TermQuery(term);
            foundDocuments = indexSearcher.search((Query)termQuery, 50);
            log.trace("Repository initial state, total: {}, docs: {}", (Object)reader.maxDoc(), LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader).stream().map(LuceneTestsUtils.documentStringFormatter).toList());
            Assertions.assertEquals((int)2, (int)reader.maxDoc());
            Assertions.assertEquals((int)1, (int)foundDocuments.scoreDocs.length);
            for (ScoreDoc foundDocument : foundDocuments.scoreDocs) {
                foundDoc = reader.storedFields().document(foundDocument.doc);
                log.trace("[1] Found document for first edit: \n\t* {}", (Object)foundDoc);
            }
            ScoreDoc[] doc = new Document();
            doc.add((IndexableField)new StringField(ID_FIELD, flagsOneOne, Field.Store.YES));
            doc.add((IndexableField)new StringField(FLAGS_FIELD, seenFlag, Field.Store.YES));
            writer.updateDocument(term, (Iterable)doc);
        }
        reader = DirectoryReader.open((IndexWriter)writer);
        try {
            indexSearcher = new IndexSearcher((IndexReader)reader);
            term = new Term(ID_FIELD, flagsOneOne);
            termQuery = new TermQuery(term);
            foundDocuments = indexSearcher.search((Query)termQuery, 50);
            log.trace("After first edit, total: {}, found: {} docs matching term: '{}', all documents after first update: {}", new Object[]{reader.maxDoc(), foundDocuments.scoreDocs.length, term, LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader).stream().map(LuceneTestsUtils.documentStringFormatter).toList()});
            Assertions.assertEquals((int)2, (int)reader.maxDoc());
            Assertions.assertEquals((int)1, (int)foundDocuments.scoreDocs.length);
            for (ScoreDoc foundDocument : foundDocuments.scoreDocs) {
                foundDoc = reader.storedFields().document(foundDocument.doc);
                log.trace("[1] Found document for second edit: \n\t* {}", (Object)foundDoc);
            }
            Document newDoc = new Document();
            newDoc.add((IndexableField)new StringField(ID_FIELD, flagsOneOne, Field.Store.YES));
            newDoc.add((IndexableField)new StringField(FLAGS_FIELD, answeredFlag, Field.Store.YES));
            writer.updateDocument(term, (Iterable)newDoc);
            log.trace("[2] Updated document for second edit (with term '{}'): \n\t* {}", (Object)term, (Object)newDoc);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = DirectoryReader.open((IndexWriter)writer);
        try {
            indexSearcher = new IndexSearcher((IndexReader)reader);
            term = new Term(ID_FIELD, flagsOneOne);
            termQuery = new TermQuery(term);
            foundDocuments = indexSearcher.search((Query)termQuery, 50);
            log.trace("After second edit, total: {}, found: {} docs matching term: '{}', all documents after first update: {}", new Object[]{reader.maxDoc(), foundDocuments.scoreDocs.length, term, LuceneTestsUtils.getAllDocumentsFromRepository((IndexReader)reader).stream().map(LuceneTestsUtils.documentStringFormatter).toList()});
            Assertions.assertEquals((int)2, (int)reader.maxDoc());
            Assertions.assertEquals((int)1, (int)foundDocuments.scoreDocs.length);
            for (ScoreDoc foundDocument : foundDocuments.scoreDocs) {
                foundDoc = reader.storedFields().document(foundDocument.doc);
                log.trace("Found document *after* second edit: \n\t* {}", (Object)foundDoc);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

