/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.task;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.jpa.model.JPADomain;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.JpaMailboxManagerProvider;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.jpa.quota.JpaCurrentQuotaManager;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasServiceContract;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.jpa.JPAUsersRepository;
import org.apache.james.user.jpa.model.JPAUser;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

class JPARecomputeCurrentQuotasServiceTest
implements RecomputeCurrentQuotasServiceContract {
    static final DomainList NO_DOMAIN_LIST = null;
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create((List)ImmutableList.builder().addAll(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES).addAll(JPAMailboxFixture.QUOTA_PERSISTANCE_CLASSES).add(JPAUser.class).add(JPADomain.class).build());
    JPAUsersRepository usersRepository;
    StoreMailboxManager mailboxManager;
    SessionProvider sessionProvider;
    CurrentQuotaManager currentQuotaManager;
    UserQuotaRootResolver userQuotaRootResolver;
    RecomputeCurrentQuotasService testee;

    JPARecomputeCurrentQuotasServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        EntityManagerFactory entityManagerFactory = JPA_TEST_CLUSTER.getEntityManagerFactory();
        JPAMailboxSessionMapperFactory mapperFactory = new JPAMailboxSessionMapperFactory(entityManagerFactory, (UidProvider)new JPAUidProvider(entityManagerFactory), (ModSeqProvider)new JPAModSeqProvider(entityManagerFactory));
        this.usersRepository = new JPAUsersRepository(NO_DOMAIN_LIST);
        this.usersRepository.setEntityManagerFactory(JPA_TEST_CLUSTER.getEntityManagerFactory());
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("enableVirtualHosting", (Object)"false");
        this.usersRepository.configure((HierarchicalConfiguration)configuration);
        this.mailboxManager = JpaMailboxManagerProvider.provideMailboxManager(JPA_TEST_CLUSTER);
        this.sessionProvider = this.mailboxManager.getSessionProvider();
        this.currentQuotaManager = new JpaCurrentQuotaManager(entityManagerFactory);
        this.userQuotaRootResolver = new DefaultUserQuotaRootResolver(this.sessionProvider, (MailboxSessionMapperFactory)mapperFactory);
        CurrentQuotaCalculator currentQuotaCalculator = new CurrentQuotaCalculator((MailboxSessionMapperFactory)mapperFactory, (QuotaRootResolver)this.userQuotaRootResolver);
        this.testee = new RecomputeCurrentQuotasService((UsersRepository)this.usersRepository, this.currentQuotaManager, currentQuotaCalculator, this.userQuotaRootResolver, this.sessionProvider);
    }

    @AfterEach
    void tearDownJpa() {
        JPA_TEST_CLUSTER.clear((List)ImmutableList.builder().addAll(JPAMailboxFixture.MAILBOX_TABLE_NAMES).addAll(JPAMailboxFixture.QUOTA_TABLES_NAMES).add((Object)"JAMES_USER").add((Object)"JAMES_DOMAIN").build());
    }

    public UsersRepository usersRepository() {
        return this.usersRepository;
    }

    public SessionProvider sessionProvider() {
        return this.sessionProvider;
    }

    public MailboxManager mailboxManager() {
        return this.mailboxManager;
    }

    public CurrentQuotaManager currentQuotaManager() {
        return this.currentQuotaManager;
    }

    public UserQuotaRootResolver userQuotaRootResolver() {
        return this.userQuotaRootResolver;
    }

    public RecomputeCurrentQuotasService testee() {
        return this.testee;
    }
}

