/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.JPAMessageMapper;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.transaction.Mapper;
import reactor.core.publisher.Flux;

public class TransactionalMessageMapper
implements MessageMapper {
    private final JPAMessageMapper messageMapper;

    public TransactionalMessageMapper(JPAMessageMapper messageMapper) {
        this.messageMapper = messageMapper;
    }

    public MailboxCounters getMailboxCounters(Mailbox mailbox) throws MailboxException {
        return MailboxCounters.builder().mailboxId(mailbox.getMailboxId()).count(this.countMessagesInMailbox(mailbox)).unseen(this.countUnseenMessagesInMailbox(mailbox)).build();
    }

    public Flux<MessageUid> listAllMessageUids(Mailbox mailbox) {
        return this.messageMapper.listAllMessageUids(mailbox);
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType type, int limit) throws MailboxException {
        return this.messageMapper.findInMailbox(mailbox, set, type, limit);
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox mailbox, MessageRange messageRange) throws MailboxException {
        return (List)this.messageMapper.execute(() -> this.messageMapper.retrieveMessagesMarkedForDeletion(mailbox, messageRange));
    }

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox mailbox, List<MessageUid> uids) throws MailboxException {
        return (Map)this.messageMapper.execute(() -> this.messageMapper.deleteMessages(mailbox, uids));
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.countMessagesInMailbox(mailbox);
    }

    private long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.countUnseenMessagesInMailbox(mailbox);
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.messageMapper.execute(Mapper.toTransaction(() -> this.messageMapper.delete(mailbox, message)));
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.findFirstUnseenMessageUid(mailbox);
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.findRecentMessageUidsInMailbox(mailbox);
    }

    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        return (MessageMetaData)this.messageMapper.execute(() -> this.messageMapper.add(mailbox, message));
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        return (Iterator)this.messageMapper.execute(() -> this.messageMapper.updateFlags(mailbox, flagsUpdateCalculator, set));
    }

    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        return (MessageMetaData)this.messageMapper.execute(() -> this.messageMapper.copy(mailbox, original));
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        return (MessageMetaData)this.messageMapper.execute(() -> this.messageMapper.move(mailbox, original));
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.getLastUid(mailbox);
    }

    public ModSeq getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.getHighestModSeq(mailbox);
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        return this.messageMapper.getApplicableFlag(mailbox);
    }
}

