/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.JPAAnnotationMapper;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.transaction.Mapper;

public class TransactionalAnnotationMapper
implements AnnotationMapper {
    private final JPAAnnotationMapper wrapped;

    public TransactionalAnnotationMapper(JPAAnnotationMapper wrapped) {
        this.wrapped = wrapped;
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        return this.wrapped.getAllAnnotations(mailboxId);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.wrapped.getAnnotationsByKeys(mailboxId, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.wrapped.getAnnotationsByKeysWithOneDepth(mailboxId, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.wrapped.getAnnotationsByKeysWithAllDepth(mailboxId, keys);
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        try {
            this.wrapped.execute(Mapper.toTransaction(() -> this.wrapped.deleteAnnotation(mailboxId, key)));
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        try {
            this.wrapped.execute(Mapper.toTransaction(() -> this.wrapped.insertAnnotation(mailboxId, mailboxAnnotation)));
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return this.wrapped.exist(mailboxId, mailboxAnnotation);
    }

    public int countAnnotations(MailboxId mailboxId) {
        return this.wrapped.countAnnotations(mailboxId);
    }
}

