/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.Date;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.jpa.mail.MessageUtils;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class MessageUtilsTest {
    static final MessageUid MESSAGE_UID = MessageUid.of((long)1L);
    static final MessageId MESSAGE_ID = new DefaultMessageId();
    static final ThreadId THREAD_ID = ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID);
    static final int BODY_START = 16;
    static final String CONTENT = "anycontent";
    @Mock
    ModSeqProvider modSeqProvider;
    @Mock
    UidProvider uidProvider;
    @Mock
    Mailbox mailbox;
    MessageUtils messageUtils;
    MailboxMessage message;

    MessageUtilsTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.messageUtils = new MessageUtils(this.uidProvider, this.modSeqProvider);
        this.message = new SimpleMailboxMessage(MESSAGE_ID, THREAD_ID, new Date(), (long)CONTENT.length(), 16, (Content)new ByteContent(CONTENT.getBytes()), new Flags(), new PropertyBuilder().build(), this.mailbox.getMailboxId());
    }

    @Test
    void newInstanceShouldFailWhenNullUidProvider() {
        Assertions.assertThatThrownBy(() -> new MessageUtils(null, this.modSeqProvider)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void newInstanceShouldFailWhenNullModSeqProvider() {
        Assertions.assertThatThrownBy(() -> new MessageUtils(this.uidProvider, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void nextModSeqShouldCallModSeqProvider() throws Exception {
        this.messageUtils.nextModSeq(this.mailbox);
        ((ModSeqProvider)Mockito.verify((Object)this.modSeqProvider)).nextModSeq((Mailbox)ArgumentMatchers.eq((Object)this.mailbox));
    }

    @Test
    void nextUidShouldCallUidProvider() throws Exception {
        this.messageUtils.nextUid(this.mailbox);
        ((UidProvider)Mockito.verify((Object)this.uidProvider)).nextUid((Mailbox)ArgumentMatchers.eq((Object)this.mailbox));
    }

    @Test
    void enrichMesageShouldEnrichUidAndModSeq() throws Exception {
        Mockito.when((Object)this.uidProvider.nextUid((Mailbox)ArgumentMatchers.eq((Object)this.mailbox))).thenReturn((Object)MESSAGE_UID);
        Mockito.when((Object)this.modSeqProvider.nextModSeq((Mailbox)ArgumentMatchers.eq((Object)this.mailbox))).thenReturn((Object)ModSeq.of((long)11L));
        this.messageUtils.enrichMessage(this.mailbox, this.message);
        Assertions.assertThat((Comparable)this.message.getUid()).isEqualTo((Object)MESSAGE_UID);
        Assertions.assertThat((Comparable)this.message.getModSeq()).isEqualTo((Object)ModSeq.of((long)11L));
    }
}

