/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.mail.JPAMapperProvider;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.model.MapperProvider;
import org.apache.james.mailbox.store.mail.model.MessageMapperTest;
import org.apache.james.utils.UpdatableTickingClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class JpaMessageMapperTest
extends MessageMapperTest {
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);

    JpaMessageMapperTest() {
    }

    protected MapperProvider createMapperProvider() {
        return new JPAMapperProvider(JPA_TEST_CLUSTER);
    }

    protected UpdatableTickingClock updatableTickingClock() {
        return null;
    }

    @AfterEach
    void cleanUp() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }

    @Test
    public void flagsAdditionShouldReturnAnUpdatedFlagHighlightingTheAddition() throws MailboxException {
        this.saveMessages();
        this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new Flags(Flags.Flag.FLAGGED), MessageManager.FlagsUpdateMode.REPLACE));
        ModSeq modSeq = this.messageMapper.getHighestModSeq(this.benwaInboxMailbox);
        Assertions.assertThat((Optional)this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD))).contains((Object)UpdatedFlags.builder().uid(this.message1.getUid()).modSeq(modSeq.next()).oldFlags(new Flags(Flags.Flag.FLAGGED)).newFlags(new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN, Flags.Flag.FLAGGED}).build()).build());
    }

    @Test
    public void flagsReplacementShouldReturnAnUpdatedFlagHighlightingTheReplacement() throws MailboxException {
        this.saveMessages();
        ModSeq modSeq = this.messageMapper.getHighestModSeq(this.benwaInboxMailbox);
        Optional updatedFlags = this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new Flags(Flags.Flag.FLAGGED), MessageManager.FlagsUpdateMode.REPLACE));
        Assertions.assertThat((Optional)updatedFlags).contains((Object)UpdatedFlags.builder().uid(this.message1.getUid()).modSeq(modSeq.next()).oldFlags(new Flags()).newFlags(new Flags(Flags.Flag.FLAGGED)).build());
    }

    @Test
    public void flagsRemovalShouldReturnAnUpdatedFlagHighlightingTheRemoval() throws MailboxException {
        this.saveMessages();
        this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.FLAGGED, Flags.Flag.SEEN}).build(), MessageManager.FlagsUpdateMode.REPLACE));
        ModSeq modSeq = this.messageMapper.getHighestModSeq(this.benwaInboxMailbox);
        Assertions.assertThat((Optional)this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.REMOVE))).contains((Object)UpdatedFlags.builder().uid(this.message1.getUid()).modSeq(modSeq.next()).oldFlags(new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN, Flags.Flag.FLAGGED}).build()).newFlags(new Flags(Flags.Flag.FLAGGED)).build());
    }

    @Test
    public void userFlagsUpdateShouldReturnCorrectUpdatedFlags() throws MailboxException {
        this.saveMessages();
        ModSeq modSeq = this.messageMapper.getHighestModSeq(this.benwaInboxMailbox);
        Assertions.assertThat((Optional)this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new Flags("userFlag"), MessageManager.FlagsUpdateMode.ADD))).contains((Object)UpdatedFlags.builder().uid(this.message1.getUid()).modSeq(modSeq.next()).oldFlags(new Flags()).newFlags(new Flags("userFlag")).build());
    }

    @Test
    public void userFlagsUpdateShouldReturnCorrectUpdatedFlagsWhenNoop() throws MailboxException {
        this.saveMessages();
        Assertions.assertThat((Optional)this.messageMapper.updateFlags(this.benwaInboxMailbox, this.message1.getUid(), new FlagsUpdateCalculator(new Flags("userFlag"), MessageManager.FlagsUpdateMode.REMOVE))).contains((Object)UpdatedFlags.builder().uid(this.message1.getUid()).modSeq(this.message1.getModSeq()).oldFlags(new Flags()).newFlags(new Flags()).build());
    }

    @Nested
    @Disabled(value="JPA does not support saveDate.")
    class SaveDateTests {
        SaveDateTests() {
        }
    }
}

