/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.TransactionalMailboxMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMapperTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class JpaMailboxMapperTest
extends MailboxMapperTest {
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);
    final AtomicInteger counter = new AtomicInteger();

    JpaMailboxMapperTest() {
    }

    protected MailboxMapper createMailboxMapper() {
        return new TransactionalMailboxMapper(new JPAMailboxMapper(JPA_TEST_CLUSTER.getEntityManagerFactory()));
    }

    protected MailboxId generateId() {
        return JPAId.of((long)this.counter.incrementAndGet());
    }

    @AfterEach
    void cleanUp() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }

    @Test
    void invalidUidValidityShouldBeSanitized() throws Exception {
        EntityManager entityManager = JPA_TEST_CLUSTER.getEntityManagerFactory().createEntityManager();
        entityManager.getTransaction().begin();
        JPAMailbox jpaMailbox = new JPAMailbox(benwaInboxPath, -1L);
        jpaMailbox.setUidValidity(-1L);
        entityManager.persist((Object)jpaMailbox);
        entityManager.getTransaction().commit();
        Mailbox readMailbox = (Mailbox)this.mailboxMapper.findMailboxByPath(benwaInboxPath).block();
        Assertions.assertThat((boolean)readMailbox.getUidValidity().isValid()).isTrue();
    }

    @Test
    void uidValiditySanitizingShouldPersistTheSanitizedUidValidity() throws Exception {
        EntityManager entityManager = JPA_TEST_CLUSTER.getEntityManagerFactory().createEntityManager();
        entityManager.getTransaction().begin();
        JPAMailbox jpaMailbox = new JPAMailbox(benwaInboxPath, -1L);
        jpaMailbox.setUidValidity(-1L);
        entityManager.persist((Object)jpaMailbox);
        entityManager.getTransaction().commit();
        Mailbox readMailbox1 = (Mailbox)this.mailboxMapper.findMailboxByPath(benwaInboxPath).block();
        Mailbox readMailbox2 = (Mailbox)this.mailboxMapper.findMailboxByPath(benwaInboxPath).block();
        Assertions.assertThat((Object)readMailbox1.getUidValidity()).isEqualTo((Object)readMailbox2.getUidValidity());
    }
}

