/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.JPAMessageMapper;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.jpa.mail.TransactionalMailboxMapper;
import org.apache.james.mailbox.jpa.mail.TransactionalMessageMapper;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.MapperProvider;

public class JPAMapperProvider
implements MapperProvider {
    private final JpaTestCluster jpaTestCluster;

    public JPAMapperProvider(JpaTestCluster jpaTestCluster) {
        this.jpaTestCluster = jpaTestCluster;
    }

    public MailboxMapper createMailboxMapper() {
        return new TransactionalMailboxMapper(new JPAMailboxMapper(this.jpaTestCluster.getEntityManagerFactory()));
    }

    public MessageMapper createMessageMapper() {
        EntityManagerFactory entityManagerFactory = this.jpaTestCluster.getEntityManagerFactory();
        JPAMessageMapper messageMapper = new JPAMessageMapper((UidProvider)new JPAUidProvider(entityManagerFactory), (ModSeqProvider)new JPAModSeqProvider(entityManagerFactory), entityManagerFactory);
        return new TransactionalMessageMapper(messageMapper);
    }

    public AttachmentMapper createAttachmentMapper() throws MailboxException {
        throw new NotImplementedException("not implemented");
    }

    public MailboxId generateId() {
        return JPAId.of((long)Math.abs(ThreadLocalRandom.current().nextInt()));
    }

    public MessageId generateMessageId() {
        return new DefaultMessageId.Factory().generate();
    }

    public boolean supportPartialAttachmentFetch() {
        return false;
    }

    public List<MapperProvider.Capabilities> getSupportedCapabilities() {
        return ImmutableList.of((Object)MapperProvider.Capabilities.ANNOTATION, (Object)MapperProvider.Capabilities.MAILBOX, (Object)MapperProvider.Capabilities.MESSAGE, (Object)MapperProvider.Capabilities.MOVE);
    }

    public MessageIdMapper createMessageIdMapper() throws MailboxException {
        throw new NotImplementedException("not implemented");
    }

    public MessageUid generateMessageUid() {
        throw new NotImplementedException("not implemented");
    }

    public ModSeq generateModSeq(Mailbox mailbox) throws MailboxException {
        throw new NotImplementedException("not implemented");
    }

    public ModSeq highestModSeq(Mailbox mailbox) throws MailboxException {
        throw new NotImplementedException("not implemented");
    }
}

