/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;

public class SimpleParserTest {
    private SimpleParser parser;

    @Before
    public void setUp() {
        this.parser = new SimpleParser();
    }

    @After
    public void tearDown() {
        this.parser = null;
    }

    @Test
    public void testNPE() {
        SimpleHandler handler = new SimpleHandler(){
            Object state;

            public void error(String errorMessage) {
            }

            public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
            }

            public void elementCData(StringBuilder cdata) {
            }

            public boolean endElement(StringBuilder name) {
                return true;
            }

            public void otherXML(StringBuilder other) {
            }

            public void saveParserState(Object state) {
                this.state = state;
            }

            public Object restoreParserState() {
                return this.state;
            }
        };
        String input = "<root test1 \"test2\"/>";
        char[] data = input.toCharArray();
        this.parser.parse(handler, data, 0, data.length);
    }

    @Test
    public void testParse() {
        String input = "<message><body>body</body><html><body><p><em>Wow</em>*, I&apos;m* <span>green</span>with <strong>envy</strong>!</p></body></html></message>";
        DomBuilderHandler domHandler = new DomBuilderHandler();
        Queue parsedElements = null;
        char[] data = input.toCharArray();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        parsedElements = domHandler.getParsedElements();
        if (parsedElements != null && parsedElements.size() > 0) {
            Element el = (Element)parsedElements.poll();
            boolean equals = input.equals(el.toString());
            System.out.println("input:  " + input);
            System.out.println("output: " + el);
            System.out.println("equals: " + equals);
            Assert.assertTrue((String)"Input and output are different!", (boolean)equals);
        }
    }

    @Test
    public void testChars() {
        SimpleHandler handler = new SimpleHandler(){
            Object state;

            public void error(String errorMessage) {
            }

            public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
            }

            public void elementCData(StringBuilder cdata) {
            }

            public boolean endElement(StringBuilder name) {
                return true;
            }

            public void otherXML(StringBuilder other) {
            }

            public void saveParserState(Object state) {
                this.state = state;
            }

            public Object restoreParserState() {
                return this.state;
            }
        };
        char[] data = "<test/>".toCharArray();
        this.parser.parse(handler, data, 0, data.length);
        handler.saveParserState(null);
        String dataStr = "<test>" + Character.toChars(127479) + "</test>";
        data = dataStr.toCharArray();
        this.parser.parse(handler, data, 0, data.length);
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        data = "<test>\u0000</test".toCharArray();
        this.parser.parse(handler, data, 0, data.length);
        Assert.assertEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
    }

    @Test
    public void testEntities() throws InstantiationException, IllegalAccessException {
        AtomicBoolean error = new AtomicBoolean(false);
        DomBuilderHandlerImpl handler = new DomBuilderHandlerImpl(error);
        char[] data = "<message from=\"test@example.com\"><body>\u00a9 \u00a7      \u2209 \u21d2 </body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertFalse((boolean)error.get());
        Assert.assertEquals((Object)"\u00a9 \u00a7      \u2209 \u21d2 ", (Object)((Element)handler.getParsedElements().poll()).getChild("body").getCData());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><body>123 - &#123;</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"123 - &#123;", (Object)((Element)handler.getParsedElements().poll()).getChild("body").getCData());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><body>123 - &a123;</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"123 - &a123;", (Object)((Element)handler.getParsedElements().poll()).getChild("body").getCData());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><body>123 - &123;</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><body>123 - &#123</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><body>123 - &a123</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\" id=\"&a123;\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"&a123;", (Object)((Element)handler.getParsedElements().poll()).getAttribute("id"));
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\" id=\"&#123;\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        Assert.assertNotEquals((Object)SimpleParser.State.ERROR, (Object)((SimpleParser.ParserState)handler.restoreParserState()).state);
        Assert.assertEquals((Object)"&#123;", (Object)((Element)handler.getParsedElements().poll()).getAttribute("id"));
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\" id=\"&123;\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\" id=\"&a123\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<mes&sage from=\"test@example.com\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<mes&amp;sage from=\"test@example.com\"></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><<body>Test</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message from=\"test@example.com\"><body>Test</body1></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<message to=\"test@zeus\" type=\"chat\" id=\"t&amp;t<\"><body>Test &amp; done</body></message>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertTrue((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<db:result to=\"malkowscy.net\" from=\"brzezinski.mobi\">CAESBxCXyf6RqCoaEGFkhIYrlYto/kK5GTcsaTw=</db:result><db:verify to=\"malkowscy.net\" from=\"brzezinski.mobi\" id=\"1B6476BAD2C0BF34\">4ab1c1d99f40263822ae7d4851854eb158e46325009e928a66b1148ee4fed331</db:verify><db:result to=\"malkowscy.net\" from=\"gmail.com\">CAESBxCXyf6RqCoaEGPHnXDLTIeKBNx9ZJ1SmzM=</db:result>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
        data = "<body xmlns:xmpp=\"urn:xmpp:xbosh\" ack=\"6621206\" from=\"test\" xmlns=\"http://jabber.org/protocol/httpbind\" secure=\"true\" xmpp:version=\"1.0\" xmlns:stream=\"http://etherx.jabber.org/streams\" host=\"mbp-andrzej.local\"><stream:features xmlns=\"jabber:client\"><auth xmlns=\"http://jabber.org/features/iq-auth\"/><mechanisms xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\"><mechanism>SCRAM-SHA-1</mechanism><mechanism>PLAIN</mechanism><mechanism>ANONYMOUS</mechanism></mechanisms><register xmlns=\"http://jabber.org/features/iq-register\"/><ver xmlns=\"urn:xmpp:features:rosterver\"/><starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/><compression xmlns=\"http://jabber.org/features/compress\"><method>zlib</method></compression></stream:features></body>".toCharArray();
        this.parser.parse((SimpleHandler)handler, data, 0, data.length);
        Assert.assertFalse((boolean)error.get());
        handler.saveParserState(null);
        handler = new DomBuilderHandlerImpl(error);
    }

    protected boolean checkIsCharValidInXML(char chr) {
        return chr == '\t' || chr == '\n' || chr == '\r' || chr >= ' ' && chr <= '\ud7ff' || chr >= '\ue000' && chr <= '\ufffd' || chr >= '\u10000' && chr <= '\u10ffff';
    }

    private class DomBuilderHandlerImpl
    extends DomBuilderHandler {
        private AtomicBoolean error;

        public DomBuilderHandlerImpl(AtomicBoolean error) {
            this.error = error;
        }

        public void error(String errorMessage) {
            this.error.set(true);
        }

        public void saveParserState(Object state) {
            super.saveParserState(state);
            if (state == null) {
                this.error.set(false);
            }
        }
    }
}

