/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class ElementTest
extends TestCase {
    private static final String[] static_str_arr = new String[]{"parent", "child"};
    private static final String str_path = "parent/child";
    private static final String str_slash_path = "/parent/child";
    private static final String xmlns = "xmlns:1";
    private String c_att_name = null;
    private String c_att_value = null;
    private Element child = null;
    private String p_att_name = null;
    private String p_att_value = null;
    private Element parent = null;
    private String value = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.value = "correct-value";
        this.parent = new Element("parent");
        this.child = new Element("child");
        this.child.setXMLNS(xmlns);
        this.child.setCData(this.value);
        this.child.setCData(this.value);
        this.child.setCData(this.value);
        this.parent.addChild((XMLNodeIfc)this.child);
        this.p_att_name = "parent_att_name";
        this.p_att_value = "parent_att_value";
        this.parent.setAttribute(this.p_att_name, this.p_att_value);
        this.c_att_name = "child_att_name";
        this.c_att_value = "child_att_value";
        this.child.setAttribute(this.c_att_name, this.c_att_value);
    }

    @After
    public void tearDown() throws Exception {
        this.parent = null;
        this.child = null;
        this.value = null;
        this.p_att_name = null;
        this.p_att_value = null;
        this.c_att_name = null;
        this.c_att_value = null;
    }

    @Test
    public void testGetChildCData() {
        String result = this.parent.getChildCData(str_path);
        ElementTest.assertEquals((String)this.value, (String)result);
        result = this.parent.getChildCData(str_path.split("/"));
        ElementTest.assertEquals((String)this.value, (String)result);
        result = this.parent.getChildCDataStaticStr(str_path.split("/"));
        ElementTest.assertNull((Object)result);
        result = this.parent.getChildCDataStaticStr(static_str_arr);
        ElementTest.assertEquals((String)this.value, (String)result);
    }

    @Test
    public void testAddAttribute() {
        String attName = "key";
        String attValue = "value";
        this.parent.addAttribute(attName, attValue);
        ElementTest.assertEquals((String)attValue, (String)this.parent.getAttribute(attName));
    }

    @Test
    public void testAddAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        this.parent.removeAttribute(this.p_att_name);
        attrs.put("key1", "val1");
        attrs.put("key2", "val2");
        this.parent.addAttributes(attrs);
        ElementTest.assertEquals((int)attrs.size(), (int)this.parent.getAttributes().size());
        ElementTest.assertEquals(attrs, (Object)this.parent.getAttributes());
    }

    @Test
    public void testAddChild() {
        Element instance = new Element("elem1", "cdata1");
        this.parent.addChild((XMLNodeIfc)instance);
        ElementTest.assertEquals((Object)instance, (Object)this.parent.getChild("elem1"));
    }

    @Test
    public void testClone() {
        Element result = this.parent.clone();
        ElementTest.assertEquals((Object)this.parent, (Object)result);
    }

    @Test
    public void testFindChildStaticStr() {
        Element result = this.parent.findChildStaticStr(str_path.split("/"));
        ElementTest.assertNull((Object)result);
        result = this.parent.findChildStaticStr(str_slash_path.split("/"));
        ElementTest.assertNull((Object)result);
        result = this.parent.findChildStaticStr(static_str_arr);
        ElementTest.assertEquals((Object)this.child, (Object)result);
    }

    @Test
    public void testFindChild_StringArr() {
        Element result = this.parent.findChild(str_path.split("/"));
        ElementTest.assertEquals((Object)this.child, (Object)result);
        result = this.parent.findChild(str_slash_path.split("/"));
        ElementTest.assertEquals((Object)this.child, (Object)result);
    }

    @Test
    public void testFindChild_String() {
        Element result = this.parent.findChild(str_path);
        ElementTest.assertEquals((Object)this.child, (Object)result);
        result = this.parent.findChild(str_slash_path);
        ElementTest.assertEquals((Object)this.child, (Object)result);
    }

    @Test
    public void testGetAttribute_String() {
        ElementTest.assertEquals((String)this.p_att_value, (String)this.parent.getAttribute(this.p_att_name));
    }

    @Test
    public void testGetChildAttribute() {
        ElementTest.assertEquals((String)this.c_att_value, (String)this.parent.getChildAttribute("child", this.c_att_name));
    }

    @Test
    public void testGetAttributeStaticStr() {
        ElementTest.assertEquals((String)this.p_att_value, (String)this.parent.getAttributeStaticStr(this.p_att_name));
    }

    @Test
    public void testGetAttribute_String_String() {
        ElementTest.assertEquals((String)this.c_att_value, (String)this.parent.getAttribute(str_slash_path, this.c_att_name));
    }

    @Test
    public void testGetAttribute_StringArr_String() {
        ElementTest.assertEquals((String)this.c_att_value, (String)this.parent.getAttribute(str_slash_path.split("/"), this.c_att_name));
        ElementTest.assertEquals((String)this.c_att_value, (String)this.parent.getAttribute(static_str_arr, this.c_att_name));
    }

    @Test
    public void testGetAttributeStaticStr_String_String() {
        ElementTest.assertNull((Object)this.parent.getAttributeStaticStr(str_slash_path.split("/"), this.c_att_name));
        ElementTest.assertEquals((String)this.c_att_value, (String)this.parent.getAttributeStaticStr(static_str_arr, this.c_att_name));
    }

    @Test
    public void testGetCData_String() {
        ElementTest.assertEquals((String)this.value, (String)this.parent.getCData(str_slash_path));
    }

    @Test
    public void testGetCData_StringArr() {
        ElementTest.assertEquals((String)this.value, (String)this.parent.getCData(str_slash_path.split("/")));
    }

    @Test
    public void testGetCDataStaticStr() {
        ElementTest.assertNull((Object)this.parent.getCDataStaticStr(str_slash_path.split("/")));
        ElementTest.assertEquals((String)this.value, (String)this.parent.getCDataStaticStr(static_str_arr));
    }

    @Test
    public void testGetCData_0args() {
        ElementTest.assertEquals((String)this.value, (String)this.child.getCData());
    }

    @Test
    public void testGetChild_String() {
        ElementTest.assertEquals((Object)this.child, (Object)this.parent.getChild("child"));
        ElementTest.assertEquals((Object)this.child, (Object)this.parent.getChild(new String("child")));
    }

    @Test
    public void testGetChildStaticStr() {
        ElementTest.assertEquals((Object)this.child, (Object)this.parent.getChildStaticStr("child"));
        ElementTest.assertNull((Object)this.parent.getChildStaticStr(new String("child")));
    }

    @Test
    public void testGetChild_String_String() {
        ElementTest.assertEquals((Object)this.child, (Object)this.parent.getChild("child", xmlns));
        ElementTest.assertEquals((Object)this.child, (Object)this.parent.getChild(new String("child"), xmlns));
    }

    @Test
    public void testGetChildCData_String() {
        ElementTest.assertEquals((String)this.value, (String)this.parent.getChildCData(str_path));
        ElementTest.assertEquals((String)this.value, (String)this.parent.getChildCData(str_slash_path));
    }

    @Test
    public void testGetChildCData_StringArr() {
        ElementTest.assertEquals((String)this.value, (String)this.parent.getChildCData(str_path.split("/")));
        ElementTest.assertEquals((String)this.value, (String)this.parent.getChildCData(str_slash_path.split("/")));
        ElementTest.assertEquals((String)this.value, (String)this.parent.getChildCData(static_str_arr));
    }

    @Test
    public void testGetChildCDataStaticStr() {
        ElementTest.assertNull((Object)this.parent.getChildCDataStaticStr(str_path.split("/")));
        ElementTest.assertNull((String)this.value, (Object)this.parent.getChildCDataStaticStr(str_slash_path.split("/")));
        ElementTest.assertEquals((String)this.value, (String)this.parent.getChildCDataStaticStr(static_str_arr));
    }

    @Test
    public void testGetName() {
        ElementTest.assertEquals((String)"parent", (String)this.parent.getName());
    }

    @Test
    public void testGetXMLNS_0args() {
        ElementTest.assertEquals((String)xmlns, (String)this.child.getXMLNS());
    }

    @Test
    public void testGetXMLNS_String() {
        ElementTest.assertEquals((String)xmlns, (String)this.parent.getXMLNS(str_path));
        ElementTest.assertEquals((String)xmlns, (String)this.parent.getXMLNS(str_slash_path));
    }

    @Test
    public void testGetXMLNS_StringArr() {
        ElementTest.assertEquals((String)xmlns, (String)this.parent.getXMLNS(str_path.split("/")));
        ElementTest.assertEquals((String)xmlns, (String)this.parent.getXMLNS(str_slash_path.split("/")));
        ElementTest.assertEquals((String)xmlns, (String)this.parent.getXMLNS(static_str_arr));
    }

    @Test
    public void testGetXMLNSStaticStr() {
        ElementTest.assertNull((Object)this.parent.getXMLNSStaticStr(str_path.split("/")));
        ElementTest.assertNull((Object)this.parent.getXMLNSStaticStr(str_slash_path.split("/")));
        ElementTest.assertEquals((String)xmlns, (String)this.parent.getXMLNSStaticStr(static_str_arr));
    }

    @Test
    public void testRemoveAttribute() {
        this.parent.removeAttribute(this.p_att_name);
        ElementTest.assertNull((Object)this.parent.getAttributeStaticStr(this.p_att_name));
    }

    @Test
    public void testRemoveChild() {
        this.parent.removeChild(this.child);
        ElementTest.assertNull((Object)this.parent.getChild("child"));
    }

    @Test
    public void testSetAttribute() {
        this.testAddAttribute();
    }

    @Test
    public void testSetCData() {
        this.testGetCData_0args();
    }
}

