/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml.db;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.db.Types;

public class DBElement
extends Element {
    public static final String NODE = "node";
    public static final String MAP = "map";
    public static final String ENTRY = "entry";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    public boolean removed = false;

    public DBElement(String argName) {
        super(argName);
    }

    public DBElement(String argName, String attname, String attvalue) {
        super(argName, new String[]{attname}, new String[]{attvalue});
    }

    public DBElement(String argName, String argCData, StringBuilder[] att_names, StringBuilder[] att_values) {
        super(argName, argCData, att_names, att_values);
    }

    public final String formatedString(int indent, int step) {
        StringBuilder result = new StringBuilder();
        result.append("\n");
        for (int i = 0; i < indent; ++i) {
            result.append(" ");
        }
        result.append("<" + this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" " + key + "=\"" + (String)this.attributes.get(key) + "\"");
            }
        }
        String childrenStr = this.childrenFormatedString(indent + step, step);
        String cdata = this.getCData();
        if (cdata != null || childrenStr.length() > 0) {
            result.append(">");
            if (cdata != null) {
                result.append(cdata);
            }
            result.append(childrenStr);
            result.append("\n");
            for (int i = 0; i < indent; ++i) {
                result.append(" ");
            }
            result.append("</" + this.name + ">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String childrenFormatedString(int indent, int step) {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            ArrayList arrayList = this.children;
            synchronized (arrayList) {
                for (XMLNodeIfc child : this.children) {
                    if (child instanceof DBElement) {
                        result.append(((DBElement)child).formatedString(indent, step));
                        continue;
                    }
                    result.append(child.toString());
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBElement getSubnode(String name) {
        if (this.children == null) {
            return null;
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            for (XMLNodeIfc el : this.children) {
                Element elem;
                if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(NODE) || !elem.getAttribute(NAME).equals(name)) continue;
                return (DBElement)elem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getSubnodes() {
        if (this.children == null || this.children.size() == 1) {
            return null;
        }
        String[] result = new String[this.children.size() - 1];
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int idx = 0;
            for (XMLNodeIfc el : this.children) {
                Element elem;
                if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(NODE)) continue;
                result[idx++] = elem.getAttribute(NAME);
            }
        }
        return result;
    }

    public final DBElement findNode(String nodePath) {
        DBElement node;
        StringTokenizer strtok = new StringTokenizer(nodePath, "/", false);
        if (!this.getName().equals(NODE) || !this.getAttribute(NAME).equals(strtok.nextToken())) {
            return null;
        }
        for (node = this; strtok.hasMoreTokens() && node != null; node = node.getSubnode(strtok.nextToken())) {
        }
        return node;
    }

    public final void removeNode(String nodePath) {
        DBElement node;
        StringTokenizer strtok = new StringTokenizer(nodePath, "/", false);
        DBElement parent = null;
        for (node = this; strtok.hasMoreTokens() && node != null; node = node.getSubnode(strtok.nextToken())) {
            parent = node;
        }
        if (parent != null && node != null) {
            parent.removeChild(node);
        }
    }

    public final DBElement getSubnodePath(String nodePath) {
        StringTokenizer strtok = new StringTokenizer(nodePath, "/", false);
        DBElement node = this;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            DBElement tmp = node.getSubnode(token);
            if (tmp != null) {
                node = tmp;
                continue;
            }
            return null;
        }
        return node;
    }

    public final DBElement buildNodesTree(String nodePath) {
        StringTokenizer strtok = new StringTokenizer(nodePath, "/", false);
        DBElement node = this;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            DBElement tmp = node.getSubnode(token);
            if (tmp != null) {
                node = tmp;
                continue;
            }
            if (token.equals("") || token.equals("null")) {
                return null;
            }
            node = node.newSubnode(token);
        }
        return node;
    }

    public final DBElement newSubnode(String name) {
        DBElement node = new DBElement(NODE, NAME, name);
        node.addChild(new DBElement(MAP));
        this.addChild(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBElement findEntry(String key) {
        DBElement result = null;
        List<Element> entries = this.getChild(MAP).getChildren();
        if (entries != null) {
            List<Element> list = entries;
            synchronized (list) {
                for (Element elem : entries) {
                    if (!elem.getAttribute(KEY).equals(key)) continue;
                    result = (DBElement)elem;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEntry(String key) {
        List<Element> entries = this.getChild(MAP).getChildren();
        if (entries != null) {
            List<Element> list = entries;
            synchronized (list) {
                ListIterator<Element> it = entries.listIterator();
                while (it.hasNext()) {
                    if (!it.next().getAttribute(KEY).equals(key)) continue;
                    it.remove();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getEntryKeys() {
        List<Element> entries = this.getChild(MAP).getChildren();
        if (entries != null) {
            String[] result = null;
            List<Element> list = entries;
            synchronized (list) {
                result = new String[entries.size()];
                int cnt = 0;
                for (Element dbe : entries) {
                    result[cnt++] = dbe.getAttribute(KEY);
                }
            }
            return result;
        }
        return null;
    }

    public final DBElement getEntry(String key) {
        DBElement result = this.findEntry(key);
        if (result == null) {
            result = new DBElement(ENTRY, KEY, key);
            this.getChild(MAP).addChild(result);
        }
        return result;
    }

    public final void setEntry(String key, Object value) {
        block11: {
            DBElement entry;
            block10: {
                Types.DataType type = Types.DataType.valueof(value.getClass().getSimpleName());
                entry = this.getEntry(key);
                entry.setAttribute(TYPE, type.toString());
                if (!value.getClass().isArray()) break block10;
                if (entry.getChildren() != null) {
                    entry.getChildren().clear();
                }
                switch (type) {
                    case INTEGER_ARR: {
                        for (int val : (int[])value) {
                            entry.addChild(new DBElement("item", VALUE, this.encode(val)));
                        }
                        break block11;
                    }
                    case DOUBLE_ARR: {
                        for (double val : (double[])value) {
                            entry.addChild(new DBElement("item", VALUE, this.encode(val)));
                        }
                        break block11;
                    }
                    case BOOLEAN_ARR: {
                        for (boolean val : (boolean[])value) {
                            entry.addChild(new DBElement("item", VALUE, this.encode(val)));
                        }
                        break block11;
                    }
                    default: {
                        for (Object val : (Object[])value) {
                            entry.addChild(new DBElement("item", VALUE, this.encode(val)));
                        }
                        break block11;
                    }
                }
            }
            entry.setAttribute(VALUE, this.encode(value));
        }
    }

    private String encode(Object source) {
        try {
            return URLEncoder.encode(source.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return source.toString();
        }
    }

    private String decode(String source) {
        try {
            return URLDecoder.decode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return source;
        }
    }

    public final String getEntryStringValue(String key, String def) {
        return (String)this.getEntryValue(key, def);
    }

    public final String[] getEntryStringArrValue(String key, String[] def) {
        String[] result = this.getEntryValue(key, def);
        DBElement entry = this.findEntry(key);
        if (entry == null) {
            return def;
        }
        Types.DataType type = Types.DataType.valueof(entry.getAttribute(TYPE));
        switch (type) {
            case STRING_ARR: {
                break;
            }
            default: {
                result = new String[]{result.toString()};
            }
        }
        return result;
    }

    public final int getEntryIntValue(String key, int def) {
        return (Integer)this.getEntryValue(key, def);
    }

    public final int[] getEntryIntArrValue(String key, int[] def) {
        return (int[])this.getEntryValue(key, def);
    }

    public final double getEntryDoubleValue(String key, double def) {
        return (Double)this.getEntryValue(key, new Double(def));
    }

    public final double[] getEntryDoubleArrValue(String key, double[] def) {
        return (double[])this.getEntryValue(key, def);
    }

    public final Object getEntryValue(String key, Object def) {
        DBElement entry = this.findEntry(key);
        if (entry == null) {
            return def;
        }
        Types.DataType type = Types.DataType.valueof(entry.getAttribute(TYPE));
        Object result = def;
        String[] tmp_s = this.getEntryValues(key);
        int idx = -1;
        try {
            switch (type) {
                case INTEGER: {
                    result = Integer.decode(entry.getAttribute(VALUE));
                    break;
                }
                case INTEGER_ARR: {
                    int[] tmp_i = new int[tmp_s.length];
                    for (String tmp : tmp_s) {
                        tmp_i[++idx] = Integer.decode(tmp);
                    }
                    result = tmp_i;
                    break;
                }
                case LONG: {
                    result = Long.decode(entry.getAttribute(VALUE));
                    break;
                }
                case LONG_ARR: {
                    long[] tmp_l = new long[tmp_s.length];
                    for (String tmp : tmp_s) {
                        tmp_l[++idx] = Long.decode(tmp);
                    }
                    result = tmp_l;
                    break;
                }
                case STRING_ARR: {
                    result = tmp_s;
                    break;
                }
                case DOUBLE: {
                    result = new Double(Double.parseDouble(entry.getAttribute(VALUE)));
                    break;
                }
                case DOUBLE_ARR: {
                    double[] tmp_f = new double[tmp_s.length];
                    for (String tmp : tmp_s) {
                        tmp_f[++idx] = Double.parseDouble(tmp);
                    }
                    result = tmp_f;
                    break;
                }
                case BOOLEAN: {
                    result = this.parseBool(entry.getAttribute(VALUE));
                    break;
                }
                case BOOLEAN_ARR: {
                    boolean[] tmp_b = new boolean[tmp_s.length];
                    for (String tmp : tmp_s) {
                        tmp_b[++idx] = this.parseBool(tmp);
                    }
                    result = tmp_b;
                    break;
                }
                default: {
                    result = this.decode(entry.getAttribute(VALUE));
                    break;
                }
            }
        }
        catch (NullPointerException e) {
            result = def;
        }
        return result;
    }

    private boolean parseBool(String val) {
        return val != null && (val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("on"));
    }

    private final String[] getEntryValues(String key) {
        List<Element> items;
        DBElement entry = this.findEntry(key);
        if (entry != null && (items = entry.getChildren()) != null) {
            String[] result = new String[items.size()];
            int cnt = 0;
            for (Element item : items) {
                result[cnt++] = this.decode(item.getAttribute(VALUE));
            }
            return result;
        }
        return null;
    }
}

