/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import tigase.xml.CData;
import tigase.xml.DomBuilderHandler;
import tigase.xml.SimpleParser;
import tigase.xml.XMLNodeIfc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements XMLNodeIfc<Element> {
    protected String name = null;
    protected String defxmlns = null;
    protected String xmlns = null;
    protected IdentityHashMap<String, String> attributes = null;
    protected ArrayList<XMLNodeIfc> children = null;

    @Override
    public Element clone() {
        Element result = null;
        try {
            result = (Element)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.attributes = this.attributes != null ? (IdentityHashMap)this.attributes.clone() : null;
        if (this.children != null) {
            result.setChildren(this.children);
        } else {
            result.children = null;
        }
        return result;
    }

    public Element(Element element) {
        Element src = element.clone();
        this.attributes = src.attributes;
        this.name = src.name;
        this.defxmlns = src.defxmlns;
        this.xmlns = src.xmlns;
        this.children = src.children;
    }

    public Element(String argName) {
        this.setName(argName);
    }

    public Element(String argName, String argCData) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
    }

    public Element(String argName, String argCData, StringBuilder[] att_names, StringBuilder[] att_values) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, String argCData, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, Element[] children, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
        this.addChildren(Arrays.asList(children));
    }

    public List<Element> getChildren() {
        ArrayList<Element> result = new ArrayList<Element>();
        for (XMLNodeIfc node : this.children) {
            if (!(node instanceof Element)) continue;
            result.add((Element)node);
        }
        return result;
    }

    public List<Element> getChildren(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getChildren() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(List<XMLNodeIfc> children) {
        ArrayList<XMLNodeIfc> arrayList = this.children = new ArrayList();
        synchronized (arrayList) {
            for (XMLNodeIfc child : children) {
                this.children.add((XMLNodeIfc)child.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(List<Element> children) {
        if (children == null) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        ArrayList<XMLNodeIfc> arrayList = this.children;
        synchronized (arrayList) {
            for (Element child : children) {
                this.children.add((XMLNodeIfc)child.clone());
            }
        }
    }

    public String toStringNoChildren() {
        String cdata;
        StringBuilder result = new StringBuilder();
        result.append("<" + this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" " + key + "=\"" + this.attributes.get(key) + "\"");
            }
        }
        if ((cdata = this.cdataToString()) != null) {
            result.append(">");
            if (cdata != null) {
                result.append(cdata);
            }
            result.append("</" + this.name + ">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    public String toString() {
        String childrenStr;
        StringBuilder result = new StringBuilder();
        result.append("<" + this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" " + key + "=\"" + this.attributes.get(key) + "\"");
            }
        }
        if ((childrenStr = this.childrenToString()) != null && childrenStr.length() > 0) {
            result.append(">");
            result.append(childrenStr);
            result.append("</" + this.name + ">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cdataToString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            ArrayList<XMLNodeIfc> arrayList = this.children;
            synchronized (arrayList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null || !(child instanceof CData)) continue;
                    result.append(child.toString());
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String childrenToString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            ArrayList<XMLNodeIfc> arrayList = this.children;
            synchronized (arrayList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null) continue;
                    result.append(child.toString());
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(XMLNodeIfc child) {
        if (child == null) {
            throw new NullPointerException("Element child can not be null.");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        ArrayList<XMLNodeIfc> arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Element child) {
        boolean res = false;
        if (this.children != null) {
            ArrayList<XMLNodeIfc> arrayList = this.children;
            synchronized (arrayList) {
                res = this.children.remove(child);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChild(String name) {
        if (this.children != null) {
            ArrayList<XMLNodeIfc> arrayList = this.children;
            synchronized (arrayList) {
                for (XMLNodeIfc el : this.children) {
                    Element elem;
                    if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(name)) continue;
                    return elem;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChild(String name, String child_xmlns) {
        if (child_xmlns == null) {
            return this.getChild(name);
        }
        if (this.children != null) {
            ArrayList<XMLNodeIfc> arrayList = this.children;
            synchronized (arrayList) {
                for (XMLNodeIfc el : this.children) {
                    Element elem;
                    if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(name) || elem.getXMLNS() != child_xmlns && (elem.getXMLNS() == null || !elem.getXMLNS().equals(child_xmlns))) continue;
                    return elem;
                }
            }
        }
        return null;
    }

    public Element findChild(String elementPath) {
        Element child;
        StringTokenizer strtok = new StringTokenizer(elementPath, "/", false);
        if (!strtok.nextToken().equals(this.getName())) {
            return null;
        }
        for (child = this; strtok.hasMoreTokens() && child != null; child = child.getChild(strtok.nextToken())) {
        }
        return child;
    }

    public String getChildCData(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getCData(String elementPath) {
        return this.getChildCData(elementPath);
    }

    public Map<String, String> getAttributes() {
        return this.attributes != null ? new LinkedHashMap<String, String>(this.attributes) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, String> newAttributes) {
        IdentityHashMap<String, String> identityHashMap = this.attributes = new IdentityHashMap(newAttributes.size());
        synchronized (identityHashMap) {
            for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
                this.attributes.put(entry.getKey().intern(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttribute(String attName) {
        if (this.attributes != null) {
            IdentityHashMap<String, String> identityHashMap = this.attributes;
            synchronized (identityHashMap) {
                return this.attributes.get(attName);
            }
        }
        return null;
    }

    public void addAttribute(String attName, String attValue) {
        this.setAttribute(attName, attValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Map<String, String> attrs) {
        if (this.attributes == null) {
            this.attributes = new IdentityHashMap(attrs.size());
        }
        IdentityHashMap<String, String> identityHashMap = this.attributes;
        synchronized (identityHashMap) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                this.attributes.put(entry.getKey().intern(), entry.getValue());
            }
        }
    }

    public void setDefXMLNS(String ns) {
        this.defxmlns = ns.intern();
    }

    public void setXMLNS(String ns) {
        this.xmlns = ns.intern();
        this.setAttribute("xmlns", ns);
    }

    public String getXMLNS() {
        if (this.xmlns == null) {
            this.xmlns = this.getAttribute("xmlns");
            this.xmlns = this.xmlns != null ? this.xmlns.intern() : null;
        }
        return this.xmlns != null ? this.xmlns : this.defxmlns;
    }

    public String getXMLNS(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public String getAttribute(String elementPath, String att_name) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getAttribute(att_name) : null;
    }

    public void setAttribute(String elementPath, String att_name, String att_value) {
        Element child = this.findChild(elementPath);
        if (child != null) {
            child.setAttribute(att_name.intern(), att_value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new IdentityHashMap();
        }
        IdentityHashMap<String, String> identityHashMap = this.attributes;
        synchronized (identityHashMap) {
            this.attributes.put(key.intern(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String key) {
        if (this.attributes != null) {
            IdentityHashMap<String, String> identityHashMap = this.attributes;
            synchronized (identityHashMap) {
                this.attributes.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(StringBuilder[] names, StringBuilder[] values) {
        IdentityHashMap<String, String> identityHashMap = this.attributes = new IdentityHashMap(names.length);
        synchronized (identityHashMap) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                this.attributes.put(names[i].toString().intern(), values[i].toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(String[] names, String[] values) {
        IdentityHashMap<String, String> identityHashMap = this.attributes = new IdentityHashMap(names.length);
        synchronized (identityHashMap) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                this.attributes.put(names[i].intern(), values[i]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName.intern();
    }

    public String getCData() {
        return this.cdataToString();
    }

    public void setCData(String argCData) {
        this.addChild(new CData(argCData));
    }

    @Override
    public int compareTo(Element elem) {
        return this.toStringNoChildren().compareTo(elem.toStringNoChildren());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element elem = (Element)obj;
            return this.toStringNoChildren().equals(elem.toStringNoChildren());
        }
        return false;
    }

    public int hashCode() {
        return this.toStringNoChildren().hashCode();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("You must give file name as parameter.");
            System.exit(1);
        }
        FileReader file = new FileReader(args[0]);
        char[] buff = new char[1];
        SimpleParser parser = new SimpleParser();
        DomBuilderHandler dom = new DomBuilderHandler();
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(dom, buff, 0, result);
        }
        file.close();
        Queue<Element> elems = dom.getParsedElements();
        for (Element elem : elems) {
            Element clone = elem.clone();
            System.out.println(elem.toString());
        }
    }
}

