/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Arrays;
import tigase.xml.SimpleHandler;

public class SimpleParser {
    public static int MAX_ATTRIBS_NUMBER = 6;
    private static final char OPEN_BRACKET = '<';
    private static final char CLOSE_BRACKET = '>';
    private static final char QUESTION_MARK = '?';
    private static final char EXCLAMATION_MARK = '!';
    private static final char SLASH = '/';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char EQUALS = '=';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char[] QUOTES = new char[]{'\'', '\"'};
    private static final char[] WHITE_CHARS = new char[]{' ', '\t', '\n', '\r'};
    private static final char[] END_NAME_CHARS = new char[]{'>', '/', ' ', '\t', '\n', '\r'};
    private static final char[] ERR_NAME_CHARS = new char[]{'<', '?'};
    private static final char[] IGNORE_CHARS = new char[]{'\u0000'};

    private boolean isWhite(char chr) {
        return Arrays.binarySearch(WHITE_CHARS, chr) >= 0;
    }

    private boolean ignore(char chr) {
        return Arrays.binarySearch(IGNORE_CHARS, chr) >= 0;
    }

    private StringBuilder[] initArray(int size) {
        Object[] array = new StringBuilder[size];
        Arrays.fill(array, null);
        return array;
    }

    private StringBuilder[] resizeArray(StringBuilder[] src, int size) {
        Object[] array = new StringBuilder[size];
        System.arraycopy(src, 0, array, 0, src.length);
        Arrays.fill(array, src.length, array.length, null);
        return array;
    }

    public final void parse(SimpleHandler handler, char[] data, int off, int len) {
        char chr;
        ParserState parser_state = (ParserState)handler.restoreParserState();
        if (parser_state == null) {
            parser_state = new ParserState();
        }
        block17: for (int index = off; index < len && !this.ignore(chr = data[index]); ++index) {
            switch (parser_state.state) {
                case START: {
                    if (chr != '<') continue block17;
                    parser_state.state = State.OPEN_BRACKET;
                    parser_state.slash_found = false;
                    continue block17;
                }
                case OPEN_BRACKET: {
                    switch (chr) {
                        case '!': 
                        case '?': {
                            parser_state.state = State.OTHER_XML;
                            parser_state.element_cdata = new StringBuilder();
                            parser_state.element_cdata.append(chr);
                            continue block17;
                        }
                        case '/': {
                            parser_state.state = State.CLOSE_ELEMENT;
                            parser_state.element_name = new StringBuilder();
                            parser_state.slash_found = true;
                            continue block17;
                        }
                    }
                    if (Arrays.binarySearch(WHITE_CHARS, chr) >= 0) continue block17;
                    parser_state.state = State.ELEMENT_NAME;
                    parser_state.element_name = new StringBuilder();
                    parser_state.element_name.append(chr);
                    continue block17;
                }
                case ELEMENT_NAME: {
                    if (this.isWhite(chr)) {
                        parser_state.state = State.END_ELEMENT_NAME;
                        continue block17;
                    }
                    if (chr == '/') {
                        parser_state.slash_found = true;
                        continue block17;
                    }
                    if (chr == '>') {
                        parser_state.state = State.ELEMENT_CDATA;
                        handler.startElement(parser_state.element_name, null, null);
                        if (parser_state.slash_found) {
                            handler.endElement(parser_state.element_name);
                            parser_state.state = State.START;
                        }
                        parser_state.element_name = null;
                        continue block17;
                    }
                    if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1]) {
                        parser_state.state = State.ERROR;
                        parser_state.errorMessage = "Not allowed character in start element name: " + chr + "\nExisting characters in start element name: " + parser_state.element_name.toString();
                        continue block17;
                    }
                    parser_state.element_name.append(chr);
                    continue block17;
                }
                case CLOSE_ELEMENT: {
                    if (this.isWhite(chr)) continue block17;
                    if (chr == '/') {
                        parser_state.state = State.ERROR;
                        parser_state.errorMessage = "Not allowed character in close element name: " + chr + "\nExisting characters in close element name: " + parser_state.element_name.toString();
                        continue block17;
                    }
                    if (chr == '>') {
                        parser_state.state = State.START;
                        handler.endElement(parser_state.element_name);
                        parser_state.element_name = null;
                        continue block17;
                    }
                    if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1]) {
                        parser_state.state = State.ERROR;
                        parser_state.errorMessage = "Not allowed character in close element name: " + chr + "\nExisting characters in close element name: " + parser_state.element_name.toString();
                        continue block17;
                    }
                    parser_state.element_name.append(chr);
                    continue block17;
                }
                case END_ELEMENT_NAME: {
                    if (chr == '/') {
                        parser_state.slash_found = true;
                        continue block17;
                    }
                    if (chr == '>') {
                        parser_state.state = State.ELEMENT_CDATA;
                        handler.startElement(parser_state.element_name, parser_state.attrib_names, parser_state.attrib_values);
                        if (parser_state.slash_found) {
                            handler.endElement(parser_state.element_name);
                            parser_state.state = State.START;
                        }
                        parser_state.element_name = null;
                        parser_state.attrib_names = null;
                        parser_state.attrib_values = null;
                        parser_state.current_attr = -1;
                        continue block17;
                    }
                    if (this.isWhite(chr)) continue block17;
                    parser_state.state = State.ATTRIB_NAME;
                    if (parser_state.attrib_names == null) {
                        parser_state.attrib_names = this.initArray(MAX_ATTRIBS_NUMBER);
                        parser_state.attrib_values = this.initArray(MAX_ATTRIBS_NUMBER);
                    } else if (parser_state.current_attr == parser_state.attrib_names.length - 1) {
                        int new_size = parser_state.attrib_names.length + MAX_ATTRIBS_NUMBER;
                        parser_state.attrib_names = this.resizeArray(parser_state.attrib_names, new_size);
                        parser_state.attrib_values = this.resizeArray(parser_state.attrib_values, new_size);
                    }
                    parser_state.attrib_names[++parser_state.current_attr] = new StringBuilder();
                    parser_state.attrib_names[parser_state.current_attr].append(chr);
                    continue block17;
                }
                case ATTRIB_NAME: {
                    if (this.isWhite(chr) || chr == '=') {
                        parser_state.state = State.END_OF_ATTR_NAME;
                        continue block17;
                    }
                    parser_state.attrib_names[parser_state.current_attr].append(chr);
                    continue block17;
                }
                case END_OF_ATTR_NAME: {
                    if (chr != '\'' && chr != '\"') continue block17;
                    parser_state.state = State.ATTRIB_VALUE;
                    parser_state.attrib_values[parser_state.current_attr] = new StringBuilder();
                    continue block17;
                }
                case ATTRIB_VALUE: {
                    if (chr == '\'' || chr == '\"') {
                        parser_state.state = State.END_ELEMENT_NAME;
                        continue block17;
                    }
                    parser_state.attrib_values[parser_state.current_attr].append(chr);
                    continue block17;
                }
                case ELEMENT_CDATA: {
                    if (chr == '<') {
                        parser_state.state = State.OPEN_BRACKET;
                        parser_state.slash_found = false;
                        if (parser_state.element_cdata == null) continue block17;
                        handler.elementCData(parser_state.element_cdata);
                        parser_state.element_cdata = null;
                        continue block17;
                    }
                    if (parser_state.element_cdata == null) {
                        if (Arrays.binarySearch(WHITE_CHARS, chr) >= 0) continue block17;
                        parser_state.element_cdata = new StringBuilder();
                        parser_state.element_cdata.append(chr);
                        continue block17;
                    }
                    parser_state.element_cdata.append(chr);
                    continue block17;
                }
                case OTHER_XML: {
                    if (chr == '>') {
                        parser_state.state = State.START;
                        handler.otherXML(parser_state.element_cdata);
                        parser_state.element_cdata = null;
                        continue block17;
                    }
                    parser_state.element_cdata.append(chr);
                    continue block17;
                }
                case ERROR: {
                    handler.error(parser_state.errorMessage);
                    parser_state = null;
                    return;
                }
                default: {
                    assert (false) : "Unknown SimpleParser state: " + (Object)((Object)parser_state.state);
                    continue block17;
                }
            }
        }
        handler.saveParserState(parser_state);
    }

    static {
        Arrays.sort(WHITE_CHARS);
        Arrays.sort(IGNORE_CHARS);
    }

    private static class ParserState {
        StringBuilder element_name = null;
        StringBuilder[] attrib_names = null;
        StringBuilder[] attrib_values = null;
        StringBuilder element_cdata = null;
        int current_attr = -1;
        boolean slash_found = false;
        State state = State.START;
        String errorMessage = null;

        private ParserState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START,
        OPEN_BRACKET,
        ELEMENT_NAME,
        END_ELEMENT_NAME,
        ATTRIB_NAME,
        END_OF_ATTR_NAME,
        ATTRIB_VALUE,
        ELEMENT_CDATA,
        OTHER_XML,
        ERROR,
        CLOSE_ELEMENT;

    }
}

