/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements Comparable<Element>,
Cloneable {
    protected String name = null;
    protected String cdata = null;
    protected String xmlns = null;
    protected LinkedHashMap<String, String> attributes = null;
    protected ArrayList<Element> children = null;

    public Element clone() {
        Element result = null;
        try {
            result = (Element)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.attributes = this.attributes != null ? (LinkedHashMap)this.attributes.clone() : null;
        if (this.children != null) {
            result.setChildren(this.children);
        } else {
            result.children = null;
        }
        return result;
    }

    public Element(Element element) {
        Element src = element.clone();
        this.attributes = src.attributes;
        this.name = src.name;
        this.cdata = src.cdata;
        this.xmlns = src.xmlns;
        this.children = src.children;
    }

    public Element(String argName) {
        this.setName(argName);
    }

    public Element(String argName, String argCData) {
        this.setName(argName);
        this.setCData(argCData);
    }

    public Element(String argName, String argCData, StringBuilder[] att_names, StringBuilder[] att_values) {
        this.setName(argName);
        this.setCData(argCData);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, String argCData, String[] att_names, String[] att_values) {
        this.setName(argName);
        this.setCData(argCData);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, Element[] children, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
        this.addChildren(Arrays.asList(children));
    }

    public List<Element> getChildren() {
        return this.children;
    }

    public List<Element> getChildren(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getChildren() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(List<Element> children) {
        ArrayList<Element> arrayList = this.children = new ArrayList();
        synchronized (arrayList) {
            for (Element child : children) {
                this.children.add(child.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(List<Element> children) {
        if (children == null) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        ArrayList<Element> arrayList = this.children;
        synchronized (arrayList) {
            for (Element child : children) {
                this.children.add(child.clone());
            }
        }
    }

    public String toStringNoChildren() {
        StringBuilder result = new StringBuilder();
        result.append("<" + this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" " + key + "=\"" + this.attributes.get(key) + "\"");
            }
        }
        if (this.cdata != null) {
            result.append(">");
            if (this.cdata != null) {
                result.append(this.cdata);
            }
            result.append("</" + this.name + ">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<" + this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" " + key + "=\"" + this.attributes.get(key) + "\"");
            }
        }
        String childrenStr = this.childrenToString();
        if (this.cdata != null || childrenStr.length() > 0) {
            result.append(">");
            if (this.cdata != null) {
                result.append(this.cdata);
            }
            result.append(childrenStr);
            result.append("</" + this.name + ">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String childrenToString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            ArrayList<Element> arrayList = this.children;
            synchronized (arrayList) {
                for (Element child : this.children) {
                    if (child == null) continue;
                    result.append(child.toString());
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Element child) {
        if (child == null) {
            throw new NullPointerException("Element child can not be null.");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        ArrayList<Element> arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Element child) {
        boolean res = false;
        if (this.children != null) {
            ArrayList<Element> arrayList = this.children;
            synchronized (arrayList) {
                res = this.children.remove(child);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChild(String name) {
        if (this.children != null) {
            ArrayList<Element> arrayList = this.children;
            synchronized (arrayList) {
                for (Element el : this.children) {
                    if (!el.getName().equals(name)) continue;
                    return el;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChild(String name, String child_xmlns) {
        if (child_xmlns == null) {
            return this.getChild(name);
        }
        if (this.children != null) {
            ArrayList<Element> arrayList = this.children;
            synchronized (arrayList) {
                for (Element el : this.children) {
                    if (!el.getName().equals(name) || (el.getXMLNS() != null || child_xmlns != null) && (el.getXMLNS() == null || child_xmlns == null || !el.getXMLNS().equals(child_xmlns))) continue;
                    return el;
                }
            }
        }
        return null;
    }

    public Element findChild(String elementPath) {
        Element child;
        StringTokenizer strtok = new StringTokenizer(elementPath, "/", false);
        if (!strtok.nextToken().equals(this.getName())) {
            return null;
        }
        for (child = this; strtok.hasMoreTokens() && child != null; child = child.getChild(strtok.nextToken())) {
        }
        return child;
    }

    public String getChildCData(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getCData(String elementPath) {
        return this.getChildCData(elementPath);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> newAttributes) {
        this.attributes = new LinkedHashMap<String, String>(newAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttribute(String attName) {
        if (this.attributes != null) {
            LinkedHashMap<String, String> linkedHashMap = this.attributes;
            synchronized (linkedHashMap) {
                return this.attributes.get(attName);
            }
        }
        return null;
    }

    public void addAttribute(String attName, String attValue) {
        this.setAttribute(attName, attValue);
    }

    public void addAttributes(Map<String, String> attrs) {
        this.attributes.putAll(attrs);
    }

    public void setDefXMLNS(String ns) {
        this.xmlns = ns;
    }

    public void setXMLNS(String ns) {
        this.setAttribute("xmlns", ns);
    }

    public String getXMLNS() {
        String ns = this.getAttribute("xmlns");
        return ns != null ? ns : this.xmlns;
    }

    public String getXMLNS(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public String getAttribute(String elementPath, String att_name) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getAttribute(att_name) : null;
    }

    public void setAttribute(String elementPath, String att_name, String att_value) {
        Element child = this.findChild(elementPath);
        if (child != null) {
            child.setAttribute(att_name, att_value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap();
        }
        LinkedHashMap<String, String> linkedHashMap = this.attributes;
        synchronized (linkedHashMap) {
            this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String key) {
        if (this.attributes != null) {
            LinkedHashMap<String, String> linkedHashMap = this.attributes;
            synchronized (linkedHashMap) {
                this.attributes.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(StringBuilder[] names, StringBuilder[] values) {
        LinkedHashMap<String, String> linkedHashMap = this.attributes = new LinkedHashMap();
        synchronized (linkedHashMap) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                this.attributes.put(names[i].toString(), values[i].toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(String[] names, String[] values) {
        LinkedHashMap<String, String> linkedHashMap = this.attributes = new LinkedHashMap();
        synchronized (linkedHashMap) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                this.attributes.put(names[i], values[i]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName;
    }

    public String getCData() {
        return this.cdata;
    }

    public void setCData(String argCData) {
        this.cdata = argCData;
    }

    @Override
    public int compareTo(Element elem) {
        return this.toStringNoChildren().compareTo(elem.toStringNoChildren());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element elem = (Element)obj;
            return this.toStringNoChildren().equals(elem.toStringNoChildren());
        }
        return false;
    }

    public int hashCode() {
        return this.toStringNoChildren().hashCode();
    }

    public static void main(String[] args) {
        Element elem = new Element("Test", "This is a test", new String[]{"first-name", "last-name"}, new String[]{"Artur", "Hefczyc"});
        elem.addChild(new Element("Chile-element"));
        Element clone = elem.clone();
        System.out.println(clone.toString());
    }
}

