/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import tigase.xml.DefaultElementFactory;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.SimpleHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomBuilderHandler
implements SimpleHandler {
    private static Logger log = Logger.getLogger("tigase.xml.DomBuilderHandler");
    private static ElementFactory defaultFactory = new DefaultElementFactory();
    private ElementFactory customFactory = null;
    private Object parserState = null;
    private String top_xmlns = null;
    private LinkedList<Element> all_roots = new LinkedList();
    private Stack<Element> el_stack = new Stack();
    private Map<String, String> namespaces = new TreeMap<String, String>();

    public DomBuilderHandler(ElementFactory factory) {
        this.customFactory = factory;
    }

    public DomBuilderHandler() {
        this.customFactory = defaultFactory;
    }

    public Queue<Element> getParsedElements() {
        return this.all_roots;
    }

    @Override
    public void error(String errorMessage) {
        log.warning("XML content parse error.");
        log.warning(errorMessage);
    }

    private Element newElement(String name, String cdata, StringBuilder[] attnames, StringBuilder[] attvals) {
        return this.customFactory.elementInstance(name, cdata, attnames, attvals);
    }

    @Override
    public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
        log.finest("Start element name: " + name);
        log.finest("Element attributes names: " + Arrays.toString(attr_names));
        log.finest("Element attributes values: " + Arrays.toString(attr_values));
        if (attr_names != null) {
            for (int i = 0; i < attr_names.length && attr_names[i] != null; ++i) {
                if (!attr_names[i].toString().startsWith("xmlns:")) continue;
                this.namespaces.put(attr_names[i].substring("xmlns:".length(), attr_names[i].length()), attr_values[i].toString());
            }
        }
        String tmp_name = name.toString();
        String new_xmlns = null;
        String prefix = null;
        for (String pref : this.namespaces.keySet()) {
            if (!tmp_name.startsWith(pref)) continue;
            new_xmlns = this.namespaces.get(pref);
            tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
            prefix = pref;
        }
        Element elem = this.newElement(tmp_name, null, attr_names, attr_values);
        String ns = elem.getXMLNS();
        if (ns == null) {
            if (this.el_stack.isEmpty() || this.el_stack.peek().getXMLNS() == null) {
                elem.setDefXMLNS(this.top_xmlns);
            } else {
                elem.setDefXMLNS(this.el_stack.peek().getXMLNS());
            }
        }
        if (new_xmlns != null) {
            elem.setXMLNS(new_xmlns);
            elem.removeAttribute("xmlns:" + prefix);
        }
        this.el_stack.push(elem);
    }

    @Override
    public void elementCData(StringBuilder cdata) {
        log.finest("Element CDATA: " + cdata);
        try {
            this.el_stack.peek().setCData(cdata.toString());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public void endElement(StringBuilder name) {
        log.finest("End element name: " + name);
        if (this.el_stack.isEmpty()) {
            this.el_stack.push(this.newElement(name.toString(), null, null, null));
        }
        Element elem = this.el_stack.pop();
        if (this.el_stack.isEmpty()) {
            this.all_roots.offer(elem);
            log.finest("Adding new request: " + elem.toString());
        } else {
            this.el_stack.peek().addChild(elem);
        }
    }

    @Override
    public void otherXML(StringBuilder other) {
        log.finest("Other XML content: " + other);
    }

    @Override
    public void saveParserState(Object state) {
        this.parserState = state;
    }

    @Override
    public Object restoreParserState() {
        return this.parserState;
    }
}

