/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;

public class XMLFormatter
implements SimpleHandler {
    private PrintStream output = null;
    private int indent = 0;
    private boolean cdataWritten = false;
    private boolean openedElement = false;
    private Object parserData = null;

    public XMLFormatter(OutputStream out) {
        this.output = new PrintStream(out);
    }

    public void error(String errorMessage) {
        System.err.println(errorMessage);
    }

    public void startElement(StringBuilder name, StringBuilder[] att_names, StringBuilder[] att_values) {
        if (this.openedElement) {
            this.output.println(">");
        } else {
            this.output.println("");
        }
        for (int idx = 0; idx < this.indent; ++idx) {
            this.output.print(" ");
        }
        this.output.print("<" + name);
        if (att_names != null) {
            for (int i = 0; i < att_names.length; ++i) {
                if (att_names[i] == null) continue;
                this.output.print(" " + att_names[i] + "='" + att_values[i] + "'");
            }
        }
        this.indent += 2;
        this.cdataWritten = false;
        this.openedElement = true;
    }

    public void elementCData(StringBuilder cdata) {
        this.output.print(">");
        this.openedElement = false;
        this.output.print(cdata);
        this.cdataWritten = true;
    }

    public void endElement(StringBuilder name) {
        if (this.cdataWritten) {
            this.output.println("");
            for (int idx = 0; idx < this.indent - 2; ++idx) {
                this.output.print(" ");
            }
            this.output.print("</" + name + ">");
        } else {
            this.output.print("/>");
        }
        this.indent -= 2;
        this.cdataWritten = true;
        this.openedElement = false;
    }

    public void otherXML(StringBuilder other) {
        this.output.println("<" + other + ">");
    }

    public void saveParserState(Object object) {
        this.parserData = object;
    }

    public Object restoreParserState() {
        return this.parserData;
    }

    public void outputExtraData(String extra) {
        this.output.println(extra);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("You must give file name as parameter.");
            System.exit(1);
        }
        FileReader file = new FileReader(args[0]);
        char[] buff = new char[16384];
        SimpleParser parser = new SimpleParser();
        XMLFormatter formatter = null;
        formatter = args.length == 2 ? new XMLFormatter(new FileOutputStream(args[1])) : new XMLFormatter(System.out);
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(formatter, buff, 0, result);
        }
        file.close();
        formatter.outputExtraData("");
        formatter = null;
    }
}

