/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.muc;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.junit.Test;
import tigase.component.PacketWriter;
import tigase.component.responses.AsyncCallback;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.util.sequencer.Actions;
import tigase.workgroupqueues.util.sequencer.ISequenceAction;
import tigase.workgroupqueues.util.sequencer.Sequencer;
import tigase.xml.Element;

public class SequencerTest {
    @Test
    public void test_01() throws TigaseStringprepException {
        final ArrayList result = new ArrayList();
        PacketWriter writer = new PacketWriter(){

            public void write(Collection<Packet> packets) {
                Assert.fail();
            }

            public void write(Packet packet) {
                Assert.fail();
            }

            public void write(Packet packet, AsyncCallback callback) {
                result.add(packet.getElemName());
                try {
                    callback.onSuccess(Packet.packetInstance((Element)new Element("success")));
                }
                catch (TigaseStringprepException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        Sequencer s = new Sequencer(){

            public void onFailure() {
            }

            public void onFinish() {
            }
        };
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("1")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("2")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("3")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("4")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("5")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("6")))});
        s.run();
        Assert.assertEquals((int)6, (int)result.size());
        Assert.assertEquals((String)"1", (String)((String)result.get(0)));
        Assert.assertEquals((String)"2", (String)((String)result.get(1)));
        Assert.assertEquals((String)"3", (String)((String)result.get(2)));
        Assert.assertEquals((String)"4", (String)((String)result.get(3)));
        Assert.assertEquals((String)"5", (String)((String)result.get(4)));
        Assert.assertEquals((String)"6", (String)((String)result.get(5)));
    }

    @Test
    public void test_02() throws TigaseStringprepException {
        final ArrayList result = new ArrayList();
        PacketWriter writer = new PacketWriter(){

            public void write(Collection<Packet> packets) {
                Assert.fail();
            }

            public void write(Packet packet) {
                Assert.fail();
            }

            public void write(Packet packet, AsyncCallback callback) {
                if (packet.getElemName().equals("4")) {
                    try {
                        callback.onError(Packet.packetInstance((Element)new Element("error")), "badbad");
                    }
                    catch (TigaseStringprepException e) {
                        Assert.fail((String)e.getMessage());
                    }
                } else {
                    result.add(packet.getElemName());
                    try {
                        callback.onSuccess(Packet.packetInstance((Element)new Element("success")));
                    }
                    catch (TigaseStringprepException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        };
        Sequencer s = new Sequencer(){

            public void onFailure() {
            }

            public void onFinish() {
            }
        };
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("1")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("2")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("3")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("4"))){

            protected void onError(Packet responseStanza, String errorCondition) {
                result.add(errorCondition);
            }
        }});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("5")))});
        s.add(new ISequenceAction[]{new Actions.WriteIQPacket(writer, Packet.packetInstance((Element)new Element("6")))});
        s.run();
        Assert.assertEquals((int)4, (int)result.size());
        Assert.assertEquals((String)"1", (String)((String)result.get(0)));
        Assert.assertEquals((String)"2", (String)((String)result.get(1)));
        Assert.assertEquals((String)"3", (String)((String)result.get(2)));
        Assert.assertEquals((String)"badbad", (String)((String)result.get(3)));
    }
}

