/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.component.exceptions.RepositoryException;
import tigase.component.responses.AsyncCallback;
import tigase.component.responses.ResponseManager;
import tigase.conf.ConfigurationException;
import tigase.db.beans.DataSourceBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.junit.XMPPTestCase;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.ArrayWriter;
import tigase.workgroupqueues.StoreMock;
import tigase.workgroupqueues.WorkgroupQueuesComponentMockable;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ComponentTest
extends XMPPTestCase {
    private Kernel kernel;
    private WorkgroupQueuesComponentMockable pubsub;
    private JUnitXMLIO xmlio;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException, ConfigurationException {
        this.kernel = new Kernel();
        this.kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        this.kernel.registerBean("defaultBeanConfigurator").asClass(DSLBeanConfigurator.class).exportable().exec();
        HashMap props = new HashMap();
        ((DSLBeanConfigurator)this.kernel.getInstance(DSLBeanConfigurator.class)).setProperties(props);
        this.kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        this.kernel.registerBean("dataSourceBean").asClass(DataSourceBean.class).exportable().exec();
        this.kernel.registerBean("repositoryPool").asInstance((Object)new StoreMock()).exec();
        final ArrayWriter writer = new ArrayWriter(){

            @Override
            public void write(Packet packet, AsyncCallback callback) {
                Element e = packet.getElement();
                e.setAttribute("id", "id001");
                try {
                    packet = Packet.packetInstance((Element)e);
                }
                catch (TigaseStringprepException e1) {
                    e1.printStackTrace();
                }
                ResponseManager rp = (ResponseManager)((Kernel)ComponentTest.this.kernel.getInstance("wq#KERNEL")).getInstance(ResponseManager.class);
                rp.registerResponseHandler(packet, Long.valueOf(60000L), callback);
                super.write(packet, callback);
            }
        };
        this.kernel.registerBean("wq").asClass(WorkgroupQueuesComponentMockable.class).exec();
        this.pubsub = (WorkgroupQueuesComponentMockable)((Object)this.kernel.getInstance(WorkgroupQueuesComponentMockable.class));
        ((Kernel)this.kernel.getInstance("wq#KERNEL")).registerBean("writer").asInstance((Object)writer).exec();
        this.xmlio = new JUnitXMLIO(){

            public void close() {
            }

            public void setIgnorePresence(boolean arg0) {
            }

            public void write(Element data) throws IOException {
                try {
                    writer.clear();
                    Packet p = Packet.packetInstance((Element)data);
                    p.setXMLNS("jabber:client");
                    ComponentTest.this.pubsub.processPacket(p);
                    this.send(writer.elements);
                }
                catch (TigaseStringprepException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Test
    public void testAdHocCreate() {
        ComponentTest.test((String)"src/test/res/user.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void testAgentOffer() throws Exception {
        ComponentTest.test((String)"src/test/res/agent_offer.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void testAgentUpdate() throws Exception {
        ComponentTest.test((String)"src/test/res/agent_update.cor", (JUnitXMLIO)this.xmlio);
        Controller controller = (Controller)((Kernel)this.kernel.getInstance("wq#KERNEL")).getInstance(Controller.class);
        Queue queue = controller.getQueue(BareJID.bareJIDInstance((String)"support@workgroup.example.com"));
        Agent agentAlice = queue.getAgent(JID.jidInstance((String)"alice@example.com/work"));
        Assert.assertNotNull((Object)agentAlice);
        Assert.assertEquals((Object)3, (Object)agentAlice.getMaxChats());
        Assert.assertEquals((Object)Agent.State.chat, (Object)agentAlice.getState());
        Agent agentBob = queue.getAgent(JID.jidInstance((String)"bob@example.com/work"));
        Assert.assertNotNull((Object)agentBob);
        Assert.assertEquals((Object)7, (Object)agentBob.getMaxChats());
        Assert.assertEquals((Object)Agent.State.dnd, (Object)agentBob.getState());
    }

    @Test
    public void testPing() {
        ComponentTest.test((String)"src/test/res/ping.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void testScenario01() {
        ComponentTest.test((String)"src/test/res/scenario01.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void testUserPart() {
        ComponentTest.test((String)"src/test/res/adHocCreate.cor", (JUnitXMLIO)this.xmlio);
    }
}

