/*
 * Decompiled with CFR 0.152.
 */
package tigase.annotations;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import tigase.annotations.TigaseDeprecated;
import tigase.util.ClassUtil;

public class DeprecationTest {
    @Rule
    public ErrorCollector collector = new ErrorCollector();
    private VersionBiggerMatcher versionMatcher;

    @Test
    public void test() throws IOException, ClassNotFoundException {
        String version = System.getProperty("project.version");
        this.versionMatcher = new VersionBiggerMatcher(Version.parse(version).get());
        Set classNames = ClassUtil.getClassNamesFromDir((File)new File(System.getProperty("project.target")));
        Set classes = ClassUtil.getClassesFromNames((Set)classNames);
        classes.stream().forEach(this::checkClass);
        Assert.assertNotSame((String)"Classes not found!", (Object)0, (Object)classes.size());
    }

    private void checkClass(Class<?> cls) {
        this.checkClassAnnotations(cls);
        Arrays.stream(cls.getDeclaredFields()).forEach(this::checkFieldAnnotations);
        HashSet interfaces = new HashSet();
        for (Class<?> tmp = cls; tmp != null; tmp = tmp.getSuperclass()) {
            Class<?>[] tmpInterfaces = tmp.getInterfaces();
            if (tmpInterfaces == null) continue;
            interfaces.addAll(Arrays.asList(tmpInterfaces));
        }
        Arrays.stream(cls.getDeclaredMethods()).forEach(method -> this.checkMethodAnnotations((Method)method, interfaces));
    }

    private void checkClassAnnotations(Class<?> clazz) {
        TigaseDeprecated tigaseDeprecated = clazz.getAnnotation(TigaseDeprecated.class);
        boolean markedAsDeprecated = clazz.isAnnotationPresent(Deprecated.class);
        if (markedAsDeprecated) {
            this.collector.checkThat("Class " + clazz + " missing @TigaseDeprecated annotation", (Object)tigaseDeprecated, CoreMatchers.notNullValue());
        } else {
            this.collector.checkThat("Class " + clazz + " missing @Deprecated annotation", (Object)tigaseDeprecated, CoreMatchers.nullValue());
        }
        if (tigaseDeprecated != null) {
            Version removeIn = Version.parse(tigaseDeprecated.removeIn()).orElseGet(() -> Version.parse(tigaseDeprecated.since()).get().nextMajor());
            this.collector.checkThat("Class " + clazz + " should be removed in this version, deprecated since " + tigaseDeprecated.since(), (Object)removeIn, (Matcher)this.versionMatcher);
        }
    }

    private void checkFieldAnnotations(Field field) {
        TigaseDeprecated tigaseDeprecated = field.getAnnotation(TigaseDeprecated.class);
        boolean markedAsDeprecated = field.isAnnotationPresent(Deprecated.class);
        if (markedAsDeprecated) {
            if (tigaseDeprecated == null) {
                tigaseDeprecated = field.getDeclaringClass().getAnnotation(TigaseDeprecated.class);
            }
            this.collector.checkThat("Field " + field + " missing @TigaseDeprecated annotation", (Object)tigaseDeprecated, CoreMatchers.notNullValue());
        } else {
            this.collector.checkThat("Field " + field + " missing @Deprecated annotation", (Object)tigaseDeprecated, CoreMatchers.nullValue());
        }
        if (tigaseDeprecated != null) {
            String since = tigaseDeprecated.since();
            Version removeIn = Version.parse(tigaseDeprecated.removeIn()).orElseGet(() -> Version.parse(since).get().nextMajor());
            this.collector.checkThat("Field " + field + " should be removed in this version, deprecated since " + tigaseDeprecated.since(), (Object)removeIn, (Matcher)this.versionMatcher);
        }
    }

    private void checkMethodAnnotations(Method method, Set<Class<?>> interfaces) {
        TigaseDeprecated tigaseDeprecated = method.getAnnotation(TigaseDeprecated.class);
        boolean markedAsDeprecated = method.isAnnotationPresent(Deprecated.class);
        if (markedAsDeprecated) {
            if (tigaseDeprecated == null) {
                tigaseDeprecated = this.findTigaseDeprecationAnnotationForMethod(method, interfaces);
            }
            this.collector.checkThat("Method " + method + " missing @TigaseDeprecated annotation", (Object)tigaseDeprecated, CoreMatchers.notNullValue());
        } else {
            this.collector.checkThat("Method " + method + " missing @Deprecated annotation", (Object)tigaseDeprecated, CoreMatchers.nullValue());
        }
        if (tigaseDeprecated != null) {
            String since = tigaseDeprecated.since();
            Version removeIn = Version.parse(tigaseDeprecated.removeIn()).orElseGet(() -> Version.parse(since).get().nextMajor());
            this.collector.checkThat("Method " + method + " should be removed in this version, deprecated since " + tigaseDeprecated.since(), (Object)removeIn, (Matcher)this.versionMatcher);
        }
    }

    private TigaseDeprecated findTigaseDeprecationAnnotationForMethod(Method method, Collection<Class<?>> interfaces) {
        TigaseDeprecated tigaseDeprecated = null;
        for (Class<?> ifc : interfaces) {
            Class<?>[] tmp;
            Method ifcMethod2;
            try {
                ifcMethod2 = ifc.getDeclaredMethod(method.getName(), method.getParameterTypes());
                tigaseDeprecated = ifcMethod2.getAnnotation(TigaseDeprecated.class);
                if (tigaseDeprecated == null && (tmp = ifc.getInterfaces()) != null) {
                    tigaseDeprecated = this.findTigaseDeprecationAnnotationForMethod(method, Arrays.asList(tmp));
                }
                if (tigaseDeprecated != null) {
                    return tigaseDeprecated;
                }
            }
            catch (NoSuchMethodException | SecurityException ifcMethod2) {
                // empty catch block
            }
            try {
                ifcMethod2 = ifc.getMethod(method.getName(), method.getParameterTypes());
                tigaseDeprecated = ifcMethod2.getAnnotation(TigaseDeprecated.class);
                if (tigaseDeprecated == null && (tmp = ifc.getInterfaces()) != null) {
                    tigaseDeprecated = this.findTigaseDeprecationAnnotationForMethod(method, Arrays.asList(tmp));
                }
                if (tigaseDeprecated == null) continue;
                return tigaseDeprecated;
            }
            catch (NoSuchMethodException | SecurityException exception) {
            }
        }
        return null;
    }

    public static class VersionBiggerMatcher
    extends BaseMatcher<Version> {
        private final Version version;

        public VersionBiggerMatcher(Version version) {
            this.version = version;
        }

        public boolean matches(Object o) {
            if (o instanceof Version) {
                return this.version.compareTo((Version)o) < 0;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("version bigger than ").appendValue((Object)this.version);
        }
    }

    public static class Version
    implements Comparable<Version> {
        private final int major;
        private final int minor;
        private final int release;

        public static Optional<Version> parse(String version) {
            if (version == null || version.isEmpty()) {
                return Optional.empty();
            }
            int idx = version.indexOf("-");
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            String[] parts = version.split("\\.");
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int release = Integer.parseInt(parts[2]);
            return Optional.of(new Version(major, minor, release));
        }

        private Version(int major, int minor, int release) {
            this.major = major;
            this.minor = minor;
            this.release = release;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.release;
        }

        public Version nextMinor() {
            return new Version(this.major, this.minor + 1, 0);
        }

        public Version nextMajor() {
            return new Version(this.major + 1, 0, 0);
        }

        @Override
        public int compareTo(Version o) {
            return Long.compare(this.toLong(), o.toLong());
        }

        private long toLong() {
            return (this.major * 100 + this.minor) * 100 + this.release;
        }
    }

    public static class VersionMatcher
    extends BaseMatcher<String> {
        private final int major;
        private final int minor;
        private final int release;
        private final String version;

        public VersionMatcher(String version) {
            int idx = version.indexOf("-");
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            this.version = version;
            String[] parts = version.split("\\.");
            this.major = Integer.parseInt(parts[0]);
            this.minor = Integer.parseInt(parts[1]);
            this.release = Integer.parseInt(parts[2]);
        }

        public boolean matches(Object o) {
            if (o instanceof String) {
                String version = (String)o;
                int idx = version.indexOf("-");
                if (idx >= 0) {
                    version = version.substring(0, idx);
                }
                String[] parts = version.split("\\.");
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                int release = Integer.parseInt(parts[2]);
                if (this.major < major) {
                    return true;
                }
                return this.major == major && this.minor <= minor;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.version);
        }
    }
}

